/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.antublue.test.engine.ExtensionManager;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.exception.TestClassFailedException;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.MetadataConstants;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.predicate.AnnotationMethodPredicate;
import org.antublue.test.engine.internal.processor.ArgumentAnnotationProcessor;
import org.antublue.test.engine.internal.processor.AutoCloseAnnotationProcessor;
import org.antublue.test.engine.internal.processor.LockAnnotationProcessor;
import org.antublue.test.engine.internal.processor.RandomAnnotationProcessor;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.antublue.test.engine.internal.util.StateMachine;
import org.antublue.test.engine.internal.util.TestUtils;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ArgumentTestDescriptor
extends ExecutableTestDescriptor {
    private static final ArgumentAnnotationProcessor ARGUMENT_ANNOTATION_PROCESSOR = ArgumentAnnotationProcessor.getInstance();
    private static final RandomAnnotationProcessor RANDOM_ANNOTATION_PROCESSOR = RandomAnnotationProcessor.getInstance();
    private static final LockAnnotationProcessor LOCK_ANNOTATION_PROCESSOR = LockAnnotationProcessor.getInstance();
    private static final AutoCloseAnnotationProcessor AUTO_CLOSE_ANNOTATION_PROCESSOR = AutoCloseAnnotationProcessor.getInstance();
    private static final ExtensionManager EXTENSION_MANAGER = ExtensionManager.getInstance();
    private final Class<?> testClass;
    private final Argument testArgument;
    private final List<Method> beforeAllMethods;
    private final List<Method> afterAllMethods;

    private ArgumentTestDescriptor(Builder builder) {
        super(builder.uniqueId, builder.displayName);
        this.testClass = builder.testClass;
        this.testArgument = builder.testArgument;
        this.beforeAllMethods = builder.beforeAllMethods;
        this.afterAllMethods = builder.afterAllMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    @Override
    public void execute(ExecutionRequest executionRequest) {
        this.getStopWatch().start();
        Object testInstance = this.getParent(ExecutableTestDescriptor.class).getTestInstance();
        Preconditions.notNull((Object)testInstance, (String)"testInstance is null");
        this.setTestInstance(testInstance);
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testArgument", this.testArgument);
        if (!this.getThrowableContext().isEmpty()) {
            this.getChildren().forEach(testDescriptor -> {
                if (testDescriptor instanceof ExecutableTestDescriptor) {
                    ((ExecutableTestDescriptor)testDescriptor).execute(executionRequest);
                }
            });
            this.getStopWatch().stop();
            this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoseconds());
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.SKIP);
            executionRequest.getEngineExecutionListener().executionSkipped((TestDescriptor)this, "");
            return;
        }
        this.setExecutionRequest(executionRequest);
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        StateMachine<State> stateMachine = new StateMachine<State>(this.getUniqueId().toString());
        try {
            stateMachine.definition(State.NULL, this::begin, State.SET_ARGUMENT_FIELDS).definition(State.SET_ARGUMENT_FIELDS, this::setArgumentFields, (State[])new State[]{State.SET_RANDOM_FIELDS, State.EXECUTE_OR_SKIP}).definition(State.SET_RANDOM_FIELDS, this::setRandomFields, (State[])new State[]{State.PRE_BEFORE_ALL, State.EXECUTE_OR_SKIP}).definition(State.PRE_BEFORE_ALL, this::preBeforeAll, (State[])new State[]{State.BEFORE_ALL, State.POST_BEFORE_ALL}).definition(State.BEFORE_ALL, this::beforeAll, (State[])new State[]{State.POST_BEFORE_ALL}).definition(State.POST_BEFORE_ALL, this::postBeforeAll, (State[])new State[]{State.EXECUTE_OR_SKIP}).definition(State.EXECUTE_OR_SKIP, this::executeOrSkip, (State[])new State[]{State.PRE_AFTER_ALL}).definition(State.PRE_AFTER_ALL, this::preAfterAll, (State[])new State[]{State.AFTER_ALL, State.POST_AFTER_ALL}).definition(State.AFTER_ALL, this::afterAll, (State[])new State[]{State.POST_AFTER_ALL}).definition(State.POST_AFTER_ALL, this::postAfterAll, (State[])new State[]{State.CLOSE_AUTO_CLOSE_FIELDS}).definition(State.CLOSE_AUTO_CLOSE_FIELDS, this::closeAutoCloseFields, (State[])new State[]{State.CLEAR_ARGUMENTS_FIELDS}).definition(State.CLEAR_ARGUMENTS_FIELDS, this::clearArgumentFields, (State[])new State[]{State.END}).afterEach(() -> {
                StandardStreams.flush();
                this.throttle();
                return null;
            }).end(State.END, this::end).run(State.NULL);
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        this.setExecutionRequest(null);
        this.getStopWatch().stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoseconds());
        if (this.getThrowableContext().isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.PASS);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getParent(ClassTestDescriptor.class).getThrowableContext().add(this.getTestInstance().getClass(), new TestClassFailedException(String.format("Exception testing test class [%s]", TestUtils.getDisplayName(this.testClass))));
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.FAIL);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.getThrowableContext().getThrowables().get(0)));
        }
        StandardStreams.flush();
    }

    private State begin() {
        return State.SET_ARGUMENT_FIELDS;
    }

    private State setArgumentFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        ARGUMENT_ANNOTATION_PROCESSOR.prepare(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        if (!this.getThrowableContext().isEmpty()) {
            return State.EXECUTE_OR_SKIP;
        }
        return State.SET_RANDOM_FIELDS;
    }

    private State setRandomFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        RANDOM_ANNOTATION_PROCESSOR.prepare(this.getTestInstance(), this.getThrowableContext());
        if (!this.getThrowableContext().isEmpty()) {
            return State.EXECUTE_OR_SKIP;
        }
        return State.PRE_BEFORE_ALL;
    }

    private State preBeforeAll() {
        EXTENSION_MANAGER.preBeforeAllMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.BEFORE_ALL;
        }
        return State.POST_BEFORE_ALL;
    }

    private State beforeAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        try {
            for (Method method : this.beforeAllMethods) {
                LOCK_ANNOTATION_PROCESSOR.processLocks(method);
                TestUtils.invoke(method, this.getTestInstance(), this.testArgument, this.getThrowableContext());
                LOCK_ANNOTATION_PROCESSOR.processUnlocks(method);
                if (this.getThrowableContext().isEmpty()) continue;
                break;
            }
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        return State.POST_BEFORE_ALL;
    }

    private State postBeforeAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postBeforeAllMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        return State.EXECUTE_OR_SKIP;
    }

    private State executeOrSkip() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).execute(this.getExecutionRequest());
            }
        });
        return State.PRE_AFTER_ALL;
    }

    private State preAfterAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.preAfterAllMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.AFTER_ALL;
        }
        return State.POST_AFTER_ALL;
    }

    private State afterAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        for (Method method : this.afterAllMethods) {
            LOCK_ANNOTATION_PROCESSOR.processLocks(method);
            TestUtils.invoke(method, this.getTestInstance(), this.testArgument, this.getThrowableContext());
            LOCK_ANNOTATION_PROCESSOR.processUnlocks(method);
        }
        return State.POST_AFTER_ALL;
    }

    private State postAfterAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postAfterAllMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        return State.CLOSE_AUTO_CLOSE_FIELDS;
    }

    private State closeAutoCloseFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        AUTO_CLOSE_ANNOTATION_PROCESSOR.conclude(this.getTestInstance(), AutoCloseAnnotationProcessor.Type.AFTER_ALL, this.getThrowableContext());
        return State.CLEAR_ARGUMENTS_FIELDS;
    }

    private State clearArgumentFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        ARGUMENT_ANNOTATION_PROCESSOR.conclude(this.getTestInstance(), null, this.getThrowableContext());
        return State.END;
    }

    private State end() {
        return null;
    }

    public static class Builder {
        private Class<?> testClass;
        private int testArgumentIndex;
        private Argument testArgument;
        private List<Method> testMethods;
        private UniqueId uniqueId;
        private String displayName;
        private List<Method> beforeAllMethods;
        private List<Method> afterAllMethods;

        public Builder setTestClass(Class<?> testClass) {
            this.testClass = testClass;
            return this;
        }

        public Builder setTestArgument(int testArgumentIndex, Argument testArgument) {
            this.testArgumentIndex = testArgumentIndex;
            this.testArgument = testArgument;
            return this;
        }

        public Builder setTestMethods(List<Method> testMethods) {
            this.testMethods = testMethods;
            return this;
        }

        public void build(TestDescriptor parentTestDescriptor) {
            try {
                this.uniqueId = parentTestDescriptor.getUniqueId().append(ArgumentTestDescriptor.class.getName(), this.testArgumentIndex + "/" + this.testArgument.name());
                this.displayName = this.testArgument.name();
                this.beforeAllMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodPredicate.of(TestEngine.BeforeAll.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                this.beforeAllMethods = TestUtils.orderTestMethods(this.beforeAllMethods, HierarchyTraversalMode.TOP_DOWN);
                this.afterAllMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodPredicate.of(TestEngine.AfterAll.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
                this.afterAllMethods = TestUtils.orderTestMethods(this.afterAllMethods, HierarchyTraversalMode.BOTTOM_UP);
                ArgumentTestDescriptor testDescriptor = new ArgumentTestDescriptor(this);
                parentTestDescriptor.addChild((TestDescriptor)testDescriptor);
                for (Method testMethod : this.testMethods) {
                    new MethodTestDescriptor.Builder().setTestClass(this.testClass).setTestArgument(this.testArgumentIndex, this.testArgument).setTestMethod(testMethod).build((TestDescriptor)testDescriptor);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new TestEngineException(t);
            }
        }
    }

    private static enum State {
        NULL,
        SET_ARGUMENT_FIELDS,
        SET_RANDOM_FIELDS,
        PRE_BEFORE_ALL,
        BEFORE_ALL,
        POST_BEFORE_ALL,
        EXECUTE_OR_SKIP,
        PRE_AFTER_ALL,
        AFTER_ALL,
        POST_AFTER_ALL,
        CLEAR_ARGUMENTS_FIELDS,
        CLOSE_AUTO_CLOSE_FIELDS,
        END;

    }
}

