/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.antublue.test.engine.ExtensionManager;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.MetadataConstants;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.predicate.AnnotationMethodPredicate;
import org.antublue.test.engine.internal.processor.AutoCloseAnnotationProcessor;
import org.antublue.test.engine.internal.processor.LockAnnotationProcessor;
import org.antublue.test.engine.internal.util.ReflectionUtils;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.antublue.test.engine.internal.util.StateMachine;
import org.antublue.test.engine.internal.util.TestUtils;
import org.antublue.test.engine.internal.util.ThrowableContext;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ClassTestDescriptor
extends ExecutableTestDescriptor {
    private static final AutoCloseAnnotationProcessor AUTO_CLOSE_ANNOTATION_PROCESSOR = AutoCloseAnnotationProcessor.getInstance();
    private static final LockAnnotationProcessor LOCK_ANNOTATION_PROCESSOR = LockAnnotationProcessor.getInstance();
    private static final ExtensionManager EXTENSION_MANAGER = ExtensionManager.getInstance();
    private final Class<?> testClass;
    private final List<Method> prepareMethods;
    private final List<Method> concludeMethods;

    private ClassTestDescriptor(Builder builder) {
        super(builder.uniqueId, builder.displayName);
        this.testClass = builder.testClass;
        this.prepareMethods = builder.prepareMethods;
        this.concludeMethods = builder.concludeMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public String getTag() {
        return TestUtils.getTag(this.testClass);
    }

    @Override
    public void execute(ExecutionRequest executionRequest) {
        this.getStopWatch().start();
        this.getMetadata().put("testClass", this.testClass);
        this.setExecutionRequest(executionRequest);
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        StateMachine<State> stateMachine = new StateMachine<State>(this.getUniqueId().toString());
        try {
            stateMachine.definition(State.NULL, this::begin, State.PRE_INSTANTIATE).definition(State.PRE_INSTANTIATE, this::preInstantiate, (State[])new State[]{State.INSTANTIATE, State.POST_INSTANTIATE}).definition(State.INSTANTIATE, this::instantiate, (State[])new State[]{State.POST_INSTANTIATE}).definition(State.POST_INSTANTIATE, this::postInstantiate, (State[])new State[]{State.PRE_PREPARE, State.EXECUTE_OR_SKIP}).definition(State.PRE_PREPARE, this::prePrepare, (State[])new State[]{State.PREPARE, State.POST_PREPARE}).definition(State.PREPARE, this::prepare, (State[])new State[]{State.POST_PREPARE}).definition(State.POST_PREPARE, this::postPrepare, (State[])new State[]{State.EXECUTE_OR_SKIP}).definition(State.EXECUTE_OR_SKIP, this::executeOrSkip, (State[])new State[]{State.PRE_CONCLUDE}).definition(State.PRE_CONCLUDE, this::preConclude, (State[])new State[]{State.CONCLUDE, State.POST_CONCLUDE}).definition(State.CONCLUDE, this::conclude, (State[])new State[]{State.POST_CONCLUDE}).definition(State.POST_CONCLUDE, this::postConclude, (State[])new State[]{State.CLOSE_AUTO_CLOSE_FIELDS}).definition(State.CLOSE_AUTO_CLOSE_FIELDS, this::closeAutoCloseFields, (State[])new State[]{State.END}).afterEach(() -> {
                StandardStreams.flush();
                this.throttle();
                return null;
            }).end(State.END, this::end).run(State.NULL);
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        this.setExecutionRequest(null);
        this.setTestInstance(null);
        this.getStopWatch().stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoseconds());
        if (this.getThrowableContext().isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.PASS);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.FAIL);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.getThrowableContext().getThrowables().get(0)));
        }
        StandardStreams.flush();
    }

    private State begin() {
        return State.PRE_INSTANTIATE;
    }

    private State preInstantiate() {
        LOCK_ANNOTATION_PROCESSOR.processLock(this.getTestClass());
        EXTENSION_MANAGER.preInstantiateCallback(this.testClass, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.INSTANTIATE;
        }
        return State.END;
    }

    private State instantiate() {
        Preconditions.condition((boolean)this.getThrowableContext().isEmpty(), (String)"Programming error");
        try {
            this.setTestInstance(ReflectionUtils.newInstance(this.testClass));
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        return State.POST_INSTANTIATE;
    }

    private State postInstantiate() {
        EXTENSION_MANAGER.postInstantiateCallback(this.getTestInstance(), this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.PRE_PREPARE;
        }
        return State.END;
    }

    private State prePrepare() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.prePrepareMethodsCallback(this.getTestInstance(), this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.PREPARE;
        }
        return State.POST_PREPARE;
    }

    private State prepare() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        try {
            for (Method method : this.prepareMethods) {
                LOCK_ANNOTATION_PROCESSOR.processLocks(method);
                TestUtils.invoke(method, this.getTestInstance(), null, this.getThrowableContext());
                LOCK_ANNOTATION_PROCESSOR.processUnlocks(method);
                if (this.getThrowableContext().isEmpty()) continue;
                break;
            }
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        return State.POST_PREPARE;
    }

    private State postPrepare() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postPrepareMethodsCallback(this.getTestInstance(), this.getThrowableContext());
        return State.EXECUTE_OR_SKIP;
    }

    private State executeOrSkip() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).execute(this.getExecutionRequest());
            }
        });
        return State.PRE_CONCLUDE;
    }

    private State preConclude() {
        EXTENSION_MANAGER.preConcludeMethodsCallback(this.getTestInstance(), this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.CONCLUDE;
        }
        return State.POST_CONCLUDE;
    }

    private State conclude() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        for (Method method : this.concludeMethods) {
            LOCK_ANNOTATION_PROCESSOR.processLocks(method);
            TestUtils.invoke(method, this.getTestInstance(), null, this.getThrowableContext());
            LOCK_ANNOTATION_PROCESSOR.processUnlocks(method);
        }
        return State.POST_CONCLUDE;
    }

    private State postConclude() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postConcludeMethodsCallback(this.getTestInstance(), this.getThrowableContext());
        return State.CLOSE_AUTO_CLOSE_FIELDS;
    }

    private State closeAutoCloseFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        AUTO_CLOSE_ANNOTATION_PROCESSOR.conclude(this.getTestInstance(), AutoCloseAnnotationProcessor.Type.AFTER_CONCLUDE, this.getThrowableContext());
        return State.END;
    }

    private State end() {
        EXTENSION_MANAGER.preDestroyCallback(this.testClass, Optional.ofNullable(this.getTestInstance()), new ThrowableContext());
        LOCK_ANNOTATION_PROCESSOR.processUnlocks(this.getTestClass());
        return null;
    }

    public static class Builder {
        private Class<?> testClass;
        private List<Argument> testArguments;
        private List<Method> testMethods;
        private UniqueId uniqueId;
        private String displayName;
        private List<Method> prepareMethods;
        private List<Method> concludeMethods;

        public Builder setTestClass(Class<?> testClass) {
            this.testClass = testClass;
            return this;
        }

        public Builder setTestArguments(List<Argument> testArguments) {
            this.testArguments = testArguments;
            return this;
        }

        public Builder setTestMethods(List<Method> testMethods) {
            this.testMethods = testMethods;
            return this;
        }

        public void build(TestDescriptor parentTestDescriptor) {
            try {
                this.uniqueId = parentTestDescriptor.getUniqueId().append(ClassTestDescriptor.class.getName(), this.testClass.getName());
                this.displayName = TestUtils.getDisplayName(this.testClass);
                this.prepareMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodPredicate.of(TestEngine.Prepare.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                this.prepareMethods = TestUtils.orderTestMethods(this.prepareMethods, HierarchyTraversalMode.TOP_DOWN);
                this.concludeMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodPredicate.of(TestEngine.Conclude.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
                this.concludeMethods = TestUtils.orderTestMethods(this.concludeMethods, HierarchyTraversalMode.BOTTOM_UP);
                ClassTestDescriptor testDescriptor = new ClassTestDescriptor(this);
                parentTestDescriptor.addChild((TestDescriptor)testDescriptor);
                int testArgumentIndex = 0;
                for (Argument testArgument : this.testArguments) {
                    new ArgumentTestDescriptor.Builder().setTestClass(this.testClass).setTestArgument(testArgumentIndex, testArgument).setTestMethods(this.testMethods).build((TestDescriptor)testDescriptor);
                    ++testArgumentIndex;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new TestEngineException(t);
            }
        }
    }

    private static enum State {
        NULL,
        PRE_INSTANTIATE,
        INSTANTIATE,
        POST_INSTANTIATE,
        PRE_PREPARE,
        PREPARE,
        POST_PREPARE,
        EXECUTE_OR_SKIP,
        PRE_CONCLUDE,
        CONCLUDE,
        POST_CONCLUDE,
        CLOSE_AUTO_CLOSE_FIELDS,
        END;

    }
}

