/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.antublue.test.engine.ExtensionManager;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.predicate.AnnotationMethodPredicate;
import org.antublue.test.engine.internal.predicate.TestClassPredicate;
import org.antublue.test.engine.internal.predicate.TestMethodPredicate;
import org.antublue.test.engine.internal.util.TestUtils;
import org.antublue.test.engine.internal.util.ThrowableContext;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class EngineDescriptorFactory {
    private static final ExtensionManager EXTENSION_MANAGER = ExtensionManager.getInstance();
    private static EngineDescriptorFactory INSTANCE;

    public static synchronized EngineDescriptorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EngineDescriptorFactory();
        }
        return INSTANCE;
    }

    public EngineDescriptor createEngineDescriptor(UniqueId uniqueId, String name, EngineDiscoveryRequest engineDiscoveryRequest) {
        EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, name);
        this.discover(engineDiscoveryRequest, engineDescriptor);
        return engineDescriptor;
    }

    private void discover(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) {
        Class javaClass;
        LinkedHashSet<Object> classes = new LinkedHashSet<Object>();
        LinkedHashMap<Class, List> classArgumentMap = new LinkedHashMap<Class, List>();
        LinkedHashMap<Class, List> classMethodMap = new LinkedHashMap<Class, List>();
        List discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            try {
                ClasspathRootSelector classpathRootSelector = (ClasspathRootSelector)discoverySelector;
                List javaClasses = ReflectionSupport.findAllClassesInClasspathRoot((URI)classpathRootSelector.getClasspathRoot(), (Predicate)TestClassPredicate.TEST_CLASS_PREDICATE, className -> true);
                for (Object javaClass2 : javaClasses) {
                    List<Argument> testArguments = EngineDescriptorFactory.getArguments(javaClass2);
                    classArgumentMap.computeIfAbsent((Class)javaClass2, c -> new ArrayList()).addAll(testArguments);
                    List<Method> javaMethods = ReflectionSupport.findMethods((Class)javaClass2, (Predicate)TestMethodPredicate.TEST_METHOD_PREDICATE, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                    javaMethods = TestUtils.orderTestMethods(javaMethods, HierarchyTraversalMode.TOP_DOWN);
                    classMethodMap.computeIfAbsent((Class)javaClass2, c -> new ArrayList()).addAll(javaMethods);
                    classes.add(javaClass2);
                }
            }
            catch (Throwable t) {
                throw new TestEngineException("Exception processing ClasspathRootSelector", t);
            }
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(PackageSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            try {
                PackageSelector packageSelector = (PackageSelector)discoverySelector;
                String packageName = packageSelector.getPackageName();
                List javaClasses = ReflectionSupport.findAllClassesInPackage((String)packageName, (Predicate)TestClassPredicate.TEST_CLASS_PREDICATE, p -> true);
                for (Class javaClass3 : javaClasses) {
                    List<Argument> testArguments = EngineDescriptorFactory.getArguments(javaClass3);
                    classArgumentMap.computeIfAbsent(javaClass3, c -> new ArrayList()).addAll(testArguments);
                    Object javaMethods = ReflectionSupport.findMethods((Class)javaClass3, (Predicate)TestMethodPredicate.TEST_METHOD_PREDICATE, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                    javaMethods = TestUtils.orderTestMethods((List<Method>)javaMethods, HierarchyTraversalMode.TOP_DOWN);
                    classMethodMap.computeIfAbsent(javaClass3, c -> new ArrayList()).addAll(javaMethods);
                    classes.add(javaClass3);
                }
            }
            catch (Throwable t) {
                throw new TestEngineException("Exception processing PackageSelector", t);
            }
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClassSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            try {
                ClassSelector classSelector = (ClassSelector)discoverySelector;
                javaClass = classSelector.getJavaClass();
                if (!TestClassPredicate.TEST_CLASS_PREDICATE.test(javaClass)) continue;
                List<Argument> testArguments = EngineDescriptorFactory.getArguments(javaClass);
                classArgumentMap.computeIfAbsent(javaClass, c -> new ArrayList()).addAll(testArguments);
                List<Method> javaMethods = ReflectionSupport.findMethods((Class)javaClass, (Predicate)TestMethodPredicate.TEST_METHOD_PREDICATE, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                javaMethods = TestUtils.orderTestMethods(javaMethods, HierarchyTraversalMode.TOP_DOWN);
                classMethodMap.computeIfAbsent(javaClass, c -> new ArrayList()).addAll(javaMethods);
                classes.add(javaClass);
            }
            catch (Throwable t) {
                throw new TestEngineException("Exception processing ClassSelector", t);
            }
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(MethodSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            try {
                MethodSelector methodSelector = (MethodSelector)discoverySelector;
                javaClass = methodSelector.getJavaClass();
                Method javaMethod = methodSelector.getJavaMethod();
                if (!TestClassPredicate.TEST_CLASS_PREDICATE.test(javaClass) || !TestMethodPredicate.TEST_METHOD_PREDICATE.test(javaMethod)) continue;
                List<Argument> testArguments = EngineDescriptorFactory.getArguments(javaClass);
                classArgumentMap.computeIfAbsent(javaClass, c -> new ArrayList()).addAll(testArguments);
                classMethodMap.computeIfAbsent(javaClass, c -> new ArrayList()).add(javaMethod);
                classes.add(javaClass);
            }
            catch (Throwable t) {
                throw new TestEngineException("Exception processing MethodSelector", t);
            }
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            try {
                UniqueIdSelector uniqueIdSelector = (UniqueIdSelector)discoverySelector;
                UniqueId uniqueId = uniqueIdSelector.getUniqueId();
                List segments = uniqueId.getSegments();
                Class<?> javaClass2 = null;
                int testArgumentIndex = -1;
                Method javaMethod = null;
                block20: for (UniqueId.Segment segment : segments) {
                    String segmentType = segment.getType();
                    if (segmentType.equals(ClassTestDescriptor.class.getName())) {
                        String javaClassName = segment.getValue();
                        javaClass2 = Thread.currentThread().getContextClassLoader().loadClass(javaClassName);
                        continue;
                    }
                    if (segmentType.equals(ArgumentTestDescriptor.class.getName())) {
                        String value = segment.getValue();
                        if (value.indexOf("/") <= 0) continue;
                        testArgumentIndex = Integer.parseInt(value.substring(0, value.indexOf("/")));
                        continue;
                    }
                    if (!segmentType.equals(MethodTestDescriptor.class.getName())) continue;
                    Preconditions.notNull(javaClass2, (String)"javaClass is null, uniqueId errors");
                    String javaMethodName = segment.getValue();
                    List javaMethods = ReflectionSupport.findMethods(javaClass2, (Predicate)TestMethodPredicate.TEST_METHOD_PREDICATE, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
                    for (Method method : javaMethods) {
                        if (!method.getName().equals(javaMethodName)) continue;
                        javaMethod = method;
                        continue block20;
                    }
                }
                if (javaClass2 == null) continue;
                classes.add(javaClass2);
                List<Argument> testArguments = EngineDescriptorFactory.getArguments(javaClass2);
                if (testArgumentIndex != -1) {
                    classArgumentMap.computeIfAbsent(javaClass2, c -> new ArrayList()).add(testArguments.get(testArgumentIndex));
                } else {
                    classArgumentMap.computeIfAbsent(javaClass2, c -> new ArrayList()).addAll(testArguments);
                }
                if (javaMethod != null) {
                    classMethodMap.computeIfAbsent(javaClass2, c -> new ArrayList()).add(javaMethod);
                    continue;
                }
                List<Method> javaMethods = ReflectionSupport.findMethods(javaClass2, (Predicate)TestMethodPredicate.TEST_METHOD_PREDICATE, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                javaMethods = TestUtils.orderTestMethods(javaMethods, HierarchyTraversalMode.TOP_DOWN);
                classMethodMap.computeIfAbsent(javaClass2, c -> new ArrayList()).addAll(javaMethods);
            }
            catch (Throwable t) {
                throw new TestEngineException("Exception processing UniqueIdSelector", t);
            }
        }
        try {
            for (Class clazz : classes) {
                List arguments = (List)classArgumentMap.get(clazz);
                ThrowableContext throwableContext = new ThrowableContext();
                EXTENSION_MANAGER.postTestArgumentDiscoveryCallback(clazz, arguments, throwableContext);
                throwableContext.throwFirst();
                List testMethods = (List)classMethodMap.get(clazz);
                throwableContext.clear();
                EXTENSION_MANAGER.postTestMethodDiscoveryCallback(clazz, testMethods, throwableContext);
                throwableContext.throwFirst();
                new ClassTestDescriptor.Builder().setTestClass(clazz).setTestArguments((List)classArgumentMap.get(clazz)).setTestMethods((List)classMethodMap.get(clazz)).build((TestDescriptor)engineDescriptor);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestEngineException(t);
        }
    }

    private static Method getArumentSupplierMethod(Class<?> testClass) {
        List methods = ReflectionSupport.findMethods(testClass, (Predicate)AnnotationMethodPredicate.of(TestEngine.ArgumentSupplier.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        Method method = (Method)methods.get(0);
        method.setAccessible(true);
        return method;
    }

    private static List<Argument> getArguments(Class<?> testClass) throws Throwable {
        ArrayList<Argument> testArguments = new ArrayList<Argument>();
        Object object = EngineDescriptorFactory.getArumentSupplierMethod(testClass).invoke(null, (Object[])null);
        if (object instanceof Stream) {
            Stream stream = (Stream)object;
            stream.forEach(testArguments::add);
        } else if (object instanceof Iterable) {
            ((Iterable)object).forEach(testArguments::add);
        } else {
            throw new TestClassDefinitionException(String.format("Exception getting arguments for test class [%s]", testClass.getName()));
        }
        return testArguments;
    }
}

