/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.Optional;
import org.antublue.test.engine.Configuration;
import org.antublue.test.engine.internal.Metadata;
import org.antublue.test.engine.internal.MetadataSupport;
import org.antublue.test.engine.internal.util.StopWatch;
import org.antublue.test.engine.internal.util.ThrowableContext;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

public abstract class ExecutableTestDescriptor
extends AbstractTestDescriptor
implements MetadataSupport {
    private static final Configuration CONFIGURATION = Configuration.getInstance();
    private static long THREAD_THROTTLE_MILLISECONDS = 0L;
    private final ThrowableContext throwableContext;
    private final Metadata metadata;
    private final StopWatch stopWatch = new StopWatch();
    private ExecutionRequest executionRequest;
    private Object testInstance;

    protected ExecutableTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
        this.throwableContext = new ThrowableContext();
        this.metadata = new Metadata();
    }

    protected void throttle() {
        if (THREAD_THROTTLE_MILLISECONDS > 0L) {
            try {
                Thread.sleep(THREAD_THROTTLE_MILLISECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void setExecutionRequest(ExecutionRequest executionRequest) {
        this.executionRequest = executionRequest;
    }

    protected ExecutionRequest getExecutionRequest() {
        return this.executionRequest;
    }

    public <T> T getParent(Class<T> clazz) {
        Optional optional = this.getParent();
        Preconditions.condition((boolean)optional.isPresent(), (String)"parent is null");
        return clazz.cast(optional.get());
    }

    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    protected void setTestInstance(Object testInstance) {
        this.testInstance = testInstance;
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    public ThrowableContext getThrowableContext() {
        return this.throwableContext;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public abstract void execute(ExecutionRequest var1);

    static {
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.thread.throttle.milliseconds");
        if (optional.isPresent()) {
            try {
                THREAD_THROTTLE_MILLISECONDS = Long.parseLong(optional.get());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

