/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.predicate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class AnnotationMethodPredicate
implements Predicate<Method> {
    private final List<Class<? extends Annotation>> annotations;

    private AnnotationMethodPredicate(List<Class<? extends Annotation>> annotations) {
        this.annotations = annotations;
    }

    @Override
    public boolean test(Method method) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (!method.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public static AnnotationMethodPredicate of(Class<? extends Annotation> annotation) {
        return AnnotationMethodPredicate.of(Collections.singletonList(annotation));
    }

    @SafeVarargs
    public static AnnotationMethodPredicate of(Class<? extends Annotation> ... annotations) {
        return new AnnotationMethodPredicate(new ArrayList<Class<? extends Annotation>>(Arrays.asList(annotations)));
    }

    public static AnnotationMethodPredicate of(List<Class<? extends Annotation>> annotations) {
        return new AnnotationMethodPredicate(annotations);
    }
}

