/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.processor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.predicate.AnnotationFieldPredicate;
import org.antublue.test.engine.internal.util.ThrowableContext;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class AutoCloseAnnotationProcessor {
    private static AutoCloseAnnotationProcessor INSTANCE;
    private static final Logger LOGGER;

    private AutoCloseAnnotationProcessor() {
    }

    public static synchronized AutoCloseAnnotationProcessor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AutoCloseAnnotationProcessor();
        }
        return INSTANCE;
    }

    public void conclude(Object testInstance, Type type, ThrowableContext throwableContext) {
        LOGGER.trace("conclude() class [%s] instance [%s] type [%s]", new Object[]{testInstance.getClass(), testInstance, type});
        switch (type.ordinal()) {
            case 0: {
                this.concludeAfterEach(testInstance, throwableContext);
                break;
            }
            case 1: {
                this.concludeAfterAll(testInstance, throwableContext);
                break;
            }
            case 2: {
                this.concludeAfterConclude(testInstance, throwableContext);
                break;
            }
        }
    }

    private void concludeAfterEach(Object testInstance, ThrowableContext throwableContext) {
        LOGGER.trace("concludeAfterEach() class [%s] instance [%s]", testInstance.getClass(), testInstance);
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.AutoClose.AfterEach.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            this.close(testInstance, field, throwableContext);
        }
    }

    private void concludeAfterAll(Object testInstance, ThrowableContext throwableContext) {
        LOGGER.trace("concludeAfterAll() class [%s] instance [%s]", testInstance.getClass(), testInstance);
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.AutoClose.AfterAll.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            this.close(testInstance, field, throwableContext);
        }
    }

    private void concludeAfterConclude(Object testInstance, ThrowableContext throwableContext) {
        LOGGER.trace("concludeAfterConclude() class [%s] instance [%s]", testInstance.getClass(), testInstance);
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.AutoClose.Conclude.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            this.close(testInstance, field, throwableContext);
        }
    }

    private void close(Object testInstance, Field field, ThrowableContext throwableContext) {
        try {
            String methodName = null;
            TestEngine.AutoClose.AfterEach autoCloseAfterEachAnnotation = field.getAnnotation(TestEngine.AutoClose.AfterEach.class);
            TestEngine.AutoClose.AfterAll autoCloseAfterAllAnnotation = field.getAnnotation(TestEngine.AutoClose.AfterAll.class);
            TestEngine.AutoClose.Conclude autoCloseConcludeAnnotation = field.getAnnotation(TestEngine.AutoClose.Conclude.class);
            if (autoCloseAfterEachAnnotation == null && autoCloseAfterAllAnnotation == null && autoCloseConcludeAnnotation == null) {
                return;
            }
            if (autoCloseAfterEachAnnotation != null) {
                methodName = autoCloseAfterEachAnnotation.method();
            } else if (autoCloseAfterAllAnnotation != null) {
                methodName = autoCloseAfterAllAnnotation.method();
            } else if (autoCloseConcludeAnnotation != null) {
                methodName = autoCloseConcludeAnnotation.method();
            }
            field.setAccessible(true);
            Object o = field.get(testInstance);
            if (o == null) {
                return;
            }
            if (methodName == null || methodName.trim().isEmpty()) {
                if (o instanceof AutoCloseable) {
                    ((AutoCloseable)o).close();
                }
            } else if (!methodName.trim().isEmpty()) {
                Method method = o.getClass().getMethod(methodName.trim(), null);
                method.setAccessible(true);
                method.invoke(o, (Object[])null);
            }
        }
        catch (Throwable t) {
            throwableContext.add(testInstance.getClass(), t);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(AutoCloseAnnotationProcessor.class);
    }

    public static enum Type {
        AFTER_EACH,
        AFTER_ALL,
        AFTER_CONCLUDE;

    }
}

