/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.processor;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.predicate.AnnotationFieldPredicate;
import org.antublue.test.engine.internal.util.RandomGenerator;
import org.antublue.test.engine.internal.util.ThrowableContext;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class RandomAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomAnnotationProcessor.class);
    private static RandomAnnotationProcessor INSTANCE;
    private static final RandomGenerator RANDOM_GENERATOR;

    private RandomAnnotationProcessor() {
    }

    public static synchronized RandomAnnotationProcessor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RandomAnnotationProcessor();
        }
        return INSTANCE;
    }

    public void prepare(Object testInstance, ThrowableContext throwableContext) {
        this.prepareBooleans(testInstance, throwableContext);
        this.prepareIntegers(testInstance, throwableContext);
        this.prepareLongs(testInstance, throwableContext);
        this.prepareFloats(testInstance, throwableContext);
        this.prepareDoubles(testInstance, throwableContext);
        this.prepareBigInteger(testInstance, throwableContext);
        this.prepareBigDecimal(testInstance, throwableContext);
        this.prepareUUID(testInstance, throwableContext);
    }

    private void prepareBooleans(Object testInstance, ThrowableContext throwableContext) {
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.Random.Boolean.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            try {
                boolean value = RANDOM_GENERATOR.nextBoolean();
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(testInstance, String.valueOf(value));
                    continue;
                }
                field.set(testInstance, value);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    private void prepareIntegers(Object testInstance, ThrowableContext throwableContext) {
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.Random.Integer.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            try {
                TestEngine.Random.Integer annotation = field.getAnnotation(TestEngine.Random.Integer.class);
                int value = RANDOM_GENERATOR.nextInteger(annotation.minimum(), annotation.maximum());
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(testInstance, String.valueOf(value));
                    continue;
                }
                field.set(testInstance, value);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    private void prepareLongs(Object testInstance, ThrowableContext throwableContext) {
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.Random.Long.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            try {
                TestEngine.Random.Long annotation = field.getAnnotation(TestEngine.Random.Long.class);
                long value = RANDOM_GENERATOR.nextLong(annotation.minimum(), annotation.maximum());
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(testInstance, String.valueOf(value));
                    continue;
                }
                field.set(testInstance, value);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    private void prepareFloats(Object testInstance, ThrowableContext throwableContext) {
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.Random.Float.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            try {
                TestEngine.Random.Float annotation = field.getAnnotation(TestEngine.Random.Float.class);
                float value = RANDOM_GENERATOR.nextFloat(annotation.minimum(), annotation.maximum());
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(testInstance, String.valueOf(value));
                    continue;
                }
                field.set(testInstance, Float.valueOf(value));
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    private void prepareDoubles(Object testInstance, ThrowableContext throwableContext) {
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.Random.Double.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            try {
                TestEngine.Random.Double annotation = field.getAnnotation(TestEngine.Random.Double.class);
                double value = RANDOM_GENERATOR.nextDouble(annotation.minimum(), annotation.maximum());
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(testInstance, String.valueOf(value));
                    continue;
                }
                field.set(testInstance, value);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    private void prepareBigInteger(Object testInstance, ThrowableContext throwableContext) {
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.Random.BigInteger.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            try {
                TestEngine.Random.BigInteger annotation = field.getAnnotation(TestEngine.Random.BigInteger.class);
                BigInteger value = RANDOM_GENERATOR.nextBigInteger(annotation.minimum(), annotation.maximum());
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(testInstance, value.toString());
                    continue;
                }
                field.set(testInstance, value);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    private void prepareBigDecimal(Object testInstance, ThrowableContext throwableContext) {
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.Random.BigDecimal.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            try {
                TestEngine.Random.BigDecimal annotation = field.getAnnotation(TestEngine.Random.BigDecimal.class);
                BigDecimal value = RANDOM_GENERATOR.nextBigDecimal(annotation.minimum(), annotation.maximum());
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(testInstance, value.toString());
                    continue;
                }
                field.set(testInstance, value);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    private void prepareUUID(Object testInstance, ThrowableContext throwableContext) {
        List fields = ReflectionSupport.findFields(testInstance.getClass(), (Predicate)AnnotationFieldPredicate.of(TestEngine.Random.UUID.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            try {
                UUID uuid = UUID.randomUUID();
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(testInstance, uuid.toString());
                    continue;
                }
                field.set(testInstance, uuid);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    static {
        RANDOM_GENERATOR = RandomGenerator.getInstance();
    }
}

