/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antublue.test.engine.internal.util.StateMachineException;

public class StateMachine<T> {
    private final String id;
    private final Map<T, Set<T>> definitions;
    private final Map<T, Action<T>> actions;
    private final List<Action<T>> afterEachActions;
    private T endState;
    private Action<T> endAction;

    public StateMachine(String id) {
        this.id = id;
        this.definitions = new HashMap<T, Set<T>>();
        this.actions = new HashMap<T, Action<T>>();
        this.afterEachActions = new ArrayList<Action<T>>();
    }

    public StateMachine<T> afterEach(Action<T> afterEachAction) {
        this.afterEachActions.add(afterEachAction);
        return this;
    }

    public StateMachine<T> definition(T state, Action<T> action, T ... nextStates) throws StateMachineException {
        if (this.actions.containsKey(state)) {
            throw new StateMachineException(String.format("Action for state [%s] already defined", state));
        }
        Set set = this.definitions.computeIfAbsent(state, k -> new HashSet());
        Collections.addAll(set, nextStates);
        this.actions.put(state, action);
        return this;
    }

    public StateMachine<T> end(T state, Action<T> action) {
        this.endState = state;
        this.endAction = action;
        return this;
    }

    public void run(T initialState) throws StateMachineException {
        T state = initialState;
        do {
            Action<T> action;
            if ((action = this.actions.get(state)) == null) {
                throw new StateMachineException(String.format("No action defined for state [%s]", state));
            }
            T nextState = action.perform();
            if (nextState == null) {
                throw new StateMachineException(String.format("Action for state [%s] returned null", nextState));
            }
            if (nextState != null && !this.definitions.computeIfAbsent(state, k -> new HashSet()).contains(nextState)) {
                throw new StateMachineException(String.format("Invalid state transition [%s] -> [%s]", state, nextState));
            }
            state = nextState;
            for (Action<T> afterEachAction : this.afterEachActions) {
                afterEachAction.perform();
            }
        } while (!state.equals(this.endState));
        this.endAction.perform();
    }

    public String toString() {
        return this.id;
    }

    public static interface Action<T> {
        public T perform();
    }
}

