/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Predicate;
import org.antublue.test.engine.Configuration;

public class ThrowableUtils {
    private static final boolean STACK_TRACE_PRUNING = Configuration.getInstance().getBoolean("antublue.test.engine.stack.trace.pruning").orElse(true);
    private static final Predicate<String> EXCLUDE = s -> s.startsWith("org.antublue.test.engine.internal.") || s.startsWith("java.base/");

    private ThrowableUtils() {
    }

    public static Throwable prune(Class<?> clazz, Throwable throwable) {
        if (!STACK_TRACE_PRUNING) {
            return throwable;
        }
        Throwable rootThrowable = throwable;
        while (!ThrowableUtils.isClassInStackTrace(rootThrowable, clazz) && rootThrowable.getCause() != null) {
            rootThrowable = rootThrowable.getCause();
        }
        for (Throwable tempThrowable = rootThrowable; tempThrowable != null; tempThrowable = tempThrowable.getCause()) {
            ThrowableUtils.prune(tempThrowable);
        }
        return rootThrowable;
    }

    private static void prune(Throwable throwable) {
        ArrayList<StackTraceElement> prunedStackTraceElements = new ArrayList<StackTraceElement>();
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>(Arrays.asList(throwable.getStackTrace()));
        Collections.reverse(stackTraceElements);
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (EXCLUDE.test(stackTraceElement.toString())) continue;
            prunedStackTraceElements.add(stackTraceElement);
        }
        Collections.reverse(prunedStackTraceElements);
        throwable.setStackTrace(prunedStackTraceElements.toArray(new StackTraceElement[0]));
    }

    private static boolean isClassInStackTrace(Throwable throwable, Class<?> clazz) {
        StackTraceElement[] stackTraceElements;
        String className = clazz.getName();
        for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
            if (!stackTraceElement.toString().startsWith(className)) continue;
            return true;
        }
        return false;
    }
}

