/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.Optional;
import org.antublue.test.engine.internal.Metadata;
import org.antublue.test.engine.internal.MetadataSupport;
import org.antublue.test.engine.internal.util.StopWatch;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public abstract class ExecutableTestDescriptor
extends AbstractTestDescriptor
implements MetadataSupport {
    private final ThrowableCollector throwableCollector = new ThrowableCollector(throwable -> true);
    private final Metadata metadata = new Metadata();
    private final StopWatch stopWatch = new StopWatch();
    private ExecutionRequest executionRequest;
    private Object testInstance;

    protected ExecutableTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    public abstract void execute(ExecutionRequest var1);

    public void skip(ExecutionRequest executionRequest) {
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).skip(executionRequest);
            }
        });
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected void setExecutionRequest(ExecutionRequest executionRequest) {
        this.executionRequest = executionRequest;
    }

    protected ExecutionRequest getExecutionRequest() {
        return this.executionRequest;
    }

    protected <T> T getParent(Class<T> clazz) {
        Optional optional = this.getParent();
        Preconditions.condition((boolean)optional.isPresent(), (String)"parent is null");
        return clazz.cast(optional.get());
    }

    protected StopWatch getStopWatch() {
        return this.stopWatch;
    }

    protected void setTestInstance(Object testInstance) {
        this.testInstance = testInstance;
    }

    protected Object getTestInstance() {
        return this.testInstance;
    }

    protected ThrowableCollector getThrowableCollector() {
        return this.throwableCollector;
    }
}

