/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.extension;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import org.antublue.test.engine.internal.reflection.MethodUtils;
import org.antublue.test.engine.internal.reflection.ObjectUtils;
import org.antublue.test.engine.internal.util.Predicates;
import org.junit.platform.commons.support.HierarchyTraversalMode;

public class TestEngineExtension {
    private final Class<?> clazz;
    private final List<Method> initializeMethods;
    private final List<Method> cleanupMethods;
    private Object object;

    private TestEngineExtension(Class<?> clazz, List<Method> initializeMethods, List<Method> cleanupMethods) {
        this.clazz = clazz;
        this.initializeMethods = initializeMethods;
        this.cleanupMethods = cleanupMethods;
    }

    public void initialize() throws Throwable {
        if (this.object == null) {
            this.object = ObjectUtils.createObject(this.clazz);
        }
        for (Method method : this.initializeMethods) {
            method.invoke(this.object, new Object[0]);
        }
    }

    public void cleanup() throws Throwable {
        for (Method method : this.cleanupMethods) {
            method.invoke(this.object, new Object[0]);
        }
    }

    public static TestEngineExtension createExtension(Class<?> clazz) {
        List<Method> initializeMethods = MethodUtils.getMethods(clazz, Predicates.ENGINE_EXTENSION_INITIALIZE_METHOD, HierarchyTraversalMode.TOP_DOWN);
        initializeMethods.sort(Comparator.comparing(Method::getName));
        List<Method> cleanupMethods = MethodUtils.getMethods(clazz, Predicates.ENGINE_EXTENSION_CLEANUP_METHOD, HierarchyTraversalMode.BOTTOM_UP);
        cleanupMethods.sort(Comparator.comparing(Method::getName));
        return new TestEngineExtension(clazz, initializeMethods, cleanupMethods);
    }
}

