/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.antublue.test.engine.internal.extension.TestEngineExtension;
import org.antublue.test.engine.internal.reflection.ClassUtils;
import org.antublue.test.engine.internal.util.Predicates;

public class TestEngineExtensionManager {
    private final List<TestEngineExtension> testEngineExtensions = new ArrayList<TestEngineExtension>();

    public void load() {
        List<Class<?>> classes = ClassUtils.discoverClasses(Predicates.ENGINE_EXTENSION_CLASS);
        classes.sort(Comparator.comparing(Class::getName));
        for (Class<?> clazz : classes) {
            this.testEngineExtensions.add(TestEngineExtension.createExtension(clazz));
        }
    }

    public void initialize() throws Throwable {
        for (TestEngineExtension testEngineExtension : this.testEngineExtensions) {
            testEngineExtension.initialize();
        }
    }

    public List<Throwable> cleanup() {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        ArrayList<TestEngineExtension> testEngineExtensions = new ArrayList<TestEngineExtension>(this.testEngineExtensions);
        Collections.reverse(testEngineExtensions);
        for (TestEngineExtension testEngineExtension : testEngineExtensions) {
            try {
                testEngineExtension.cleanup();
            }
            catch (Throwable t) {
                throwables.add(t);
            }
        }
        return throwables;
    }
}

