/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.reflection;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ClassPathUtils {
    private static final ReentrantLock LOCK = new ReentrantLock(true);
    private static List<URI> URIS;

    private ClassPathUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URI> getClasspathURIs() {
        try {
            LOCK.lock();
            if (URIS == null) {
                String[] paths;
                LinkedHashSet<URI> uriSet = new LinkedHashSet<URI>();
                String classpath = System.getProperty("java.class.path");
                for (String path : paths = classpath.split(File.pathSeparator)) {
                    URI uri = new File(path).toURI();
                    uriSet.add(uri);
                }
                URIS = new ArrayList<URI>(uriSet);
            }
            List<URI> list = URIS;
            return list;
        }
        finally {
            LOCK.unlock();
        }
    }
}

