/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.reflection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.reflection.DisplayNameUtils;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.util.ClassUtils;

public class OrdererUtils {
    private static final DefaultMethodOrderTopDownComparator DEFAULT_METHOD_ORDER_TOP_DOWN_COMPARATOR = new DefaultMethodOrderTopDownComparator();
    private static final DefaultMethodOrderBottomUpComparator DEFAULT_METHOD_ORDER_BOTTOM_UP_COMPARATOR = new DefaultMethodOrderBottomUpComparator();
    private static final TestEngineOrderAnnotationMethodComparator TEST_ENGINE_ORDER_ANNOTATION_COMPARATOR = new TestEngineOrderAnnotationMethodComparator();
    private static final MethodNameComparator METHOD_NAME_COMPARATOR = new MethodNameComparator();

    private OrdererUtils() {
    }

    public static void orderTestClasses(List<Class<?>> testClasses) {
        testClasses.sort(Comparator.comparing(DisplayNameUtils::getDisplayName));
        testClasses.sort(Comparator.comparingInt(OrdererUtils::getOrderAnnotation));
    }

    public static int getOrderAnnotation(Class<?> clazz) {
        int order = Integer.MAX_VALUE;
        TestEngine.Order annotation = clazz.getAnnotation(TestEngine.Order.class);
        if (annotation != null) {
            order = annotation.order();
        }
        return order;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> orderTestMethods(List<Method> testMethods, HierarchyTraversalMode hierarchyTraversalMode) {
        LinkedHashMap<Class, List> methodMap = new LinkedHashMap<Class, List>();
        for (Method method : testMethods) {
            void var5_7;
            Class<?> clazz = method.getDeclaringClass().getComponentType();
            if (clazz == null) {
                Class<?> clazz2 = method.getDeclaringClass();
            }
            List methods = methodMap.computeIfAbsent((Class)var5_7, k -> new ArrayList());
            methods.add(method);
        }
        Comparator<Method> methodComparator = DEFAULT_METHOD_ORDER_TOP_DOWN_COMPARATOR;
        if (hierarchyTraversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            methodComparator = DEFAULT_METHOD_ORDER_BOTTOM_UP_COMPARATOR;
        }
        for (Map.Entry entry : methodMap.entrySet()) {
            ((List)entry.getValue()).sort(methodComparator);
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Class key : methodMap.keySet()) {
            List methods = (List)methodMap.get(key);
            arrayList.addAll(methods);
        }
        return arrayList;
    }

    private static class MethodNameComparator
    implements Comparator<Method> {
        private MethodNameComparator() {
        }

        @Override
        public int compare(Method method1, Method method2) {
            int comparison = method1.getName().compareTo(method2.getName());
            if (comparison == 0) {
                comparison = ClassUtils.nullSafeToString((Class[])method1.getParameterTypes()).compareTo(ClassUtils.nullSafeToString((Class[])method2.getParameterTypes()));
            }
            return comparison;
        }
    }

    private static class TestEngineOrderAnnotationMethodComparator
    implements Comparator<Method> {
        private static final int DEFAULT_ORDER = Integer.MAX_VALUE;

        private TestEngineOrderAnnotationMethodComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            int o1Order = Integer.MAX_VALUE;
            TestEngine.Order o1Annotation = o1.getAnnotation(TestEngine.Order.class);
            if (o1Annotation != null) {
                o1Order = o1Annotation.order();
            }
            int o2Order = Integer.MAX_VALUE;
            TestEngine.Order o2Annotation = o2.getAnnotation(TestEngine.Order.class);
            if (o2Annotation != null) {
                o2Order = o2Annotation.order();
            }
            return Integer.compare(o1Order, o2Order);
        }
    }

    private static class DefaultMethodOrderTopDownComparator
    implements Comparator<Method> {
        private DefaultMethodOrderTopDownComparator() {
        }

        @Override
        public int compare(Method method1, Method method2) {
            int comparison = TEST_ENGINE_ORDER_ANNOTATION_COMPARATOR.compare(method1, method2);
            if (comparison == 0) {
                comparison = METHOD_NAME_COMPARATOR.compare(method1, method2);
            }
            return comparison;
        }
    }

    private static class DefaultMethodOrderBottomUpComparator
    implements Comparator<Method> {
        private DefaultMethodOrderBottomUpComparator() {
        }

        @Override
        public int compare(Method method1, Method method2) {
            int comparison = TEST_ENGINE_ORDER_ANNOTATION_COMPARATOR.compare(method1, method2);
            if (comparison == 0) {
                comparison = -METHOD_NAME_COMPARATOR.compare(method1, method2);
            }
            return comparison;
        }
    }
}

