/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.Information;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.configuration.ConfigurationParameters;
import org.antublue.test.engine.internal.discovery.EngineDiscoveryRequestResolver;
import org.antublue.test.engine.internal.extension.TestEngineExtensionManager;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Executor;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class Engine
implements TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(Engine.class);
    public static final String ENGINE_ID = "antublue-test-engine";
    public static final String GROUP_ID = "org.antublue";
    public static final String ARTIFACT_ID = "test-engine";
    public static final String VERSION = Information.getInstance().getVersion();

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        LOGGER.trace("discover(" + uniqueId + ")");
        try {
            EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, this.getId());
            new EngineDiscoveryRequestResolver().resolveSelector(engineDiscoveryRequest, engineDescriptor);
            return engineDescriptor;
        }
        catch (TestClassDefinitionException | TestEngineException t) {
            if ("true".equals(System.getProperty("antublue.test.engine.maven.plugin"))) {
                throw t;
            }
            t.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Throwable t) {
            throw new TestEngineException("General exception", t);
        }
        return null;
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute() rootTestDescriptor children [%d]", (Object)executionRequest.getRootTestDescriptor().getChildren().size());
        if (executionRequest.getRootTestDescriptor().getChildren().isEmpty()) {
            return;
        }
        executionRequest.getEngineExecutionListener().executionStarted(executionRequest.getRootTestDescriptor());
        TestEngineExtensionManager testEngineExtensionManager = new TestEngineExtensionManager();
        testEngineExtensionManager.load();
        ThrowableCollector throwableCollector = new ThrowableCollector(throwable -> true);
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> testEngineExtensionManager.initialize());
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                Executor executor = new Executor();
                executor.execute(ExecutionRequest.create((TestDescriptor)executionRequest.getRootTestDescriptor(), (EngineExecutionListener)executionRequest.getEngineExecutionListener(), (org.junit.platform.engine.ConfigurationParameters)ConfigurationParameters.getInstance()));
                executor.await();
            });
        }
        List<Throwable> throwables = testEngineExtensionManager.cleanup();
        if (throwableCollector.isEmpty() && throwables.isEmpty()) {
            executionRequest.getEngineExecutionListener().executionFinished(executionRequest.getRootTestDescriptor(), TestExecutionResult.successful());
        } else {
            Throwable throwable2 = throwableCollector.isNotEmpty() ? throwableCollector.getThrowable() : throwables.get(0);
            executionRequest.getEngineExecutionListener().executionFinished(executionRequest.getRootTestDescriptor(), TestExecutionResult.failed((Throwable)throwable2));
        }
    }
}

