/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.configuration;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.antublue.test.engine.internal.configuration.Configuration;

public class ConfigurationParameters
implements org.junit.platform.engine.ConfigurationParameters {
    private static final Configuration CONFIGURATION = Configuration.getInstance();
    private static final Function<String, Boolean> toBoolean = string -> {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1");
    };

    private ConfigurationParameters() {
    }

    public static ConfigurationParameters getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Optional<String> get(String key) {
        return CONFIGURATION.getProperty(key);
    }

    public Optional<Boolean> getBoolean(String key) {
        return CONFIGURATION.getProperty(key, toBoolean);
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        return CONFIGURATION.getProperty(key, transformer);
    }

    public int size() {
        return CONFIGURATION.size();
    }

    public Set<String> keySet() {
        return CONFIGURATION.getPropertyNames();
    }

    private static final class SingletonHolder {
        private static final ConfigurationParameters INSTANCE = new ConfigurationParameters();

        private SingletonHolder() {
        }
    }
}

