/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.metadata.MetadataConstants;
import org.antublue.test.engine.internal.support.ArgumentAnnotationSupport;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.antublue.test.engine.internal.support.RandomAnnotationSupport;
import org.antublue.test.engine.internal.util.Predicates;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class ArgumentTestDescriptor
extends ExecutableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument<?> testArgument;
    private final List<Method> beforeAllMethods;
    private final List<Method> afterAllMethods;

    public ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument<?> testArgument, List<Method> beforeAllMethods, List<Method> afterAllMethods) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.beforeAllMethods = beforeAllMethods;
        this.afterAllMethods = afterAllMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    @Override
    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute(ExecutionRequest executionRequest)");
        this.getStopWatch().reset();
        this.setExecutionRequest(executionRequest);
        Object testInstance = this.getParent(ExecutableTestDescriptor.class).getTestInstance();
        Preconditions.notNull((Object)testInstance, (String)"testInstance is null");
        this.setTestInstance(testInstance);
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", DisplayNameSupport.getDisplayName(this.testClass));
        this.getMetadata().put("testArgument", this.testArgument);
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        throwableCollector.execute(this::setArgumentFields);
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(this::setRandomFields);
            if (throwableCollector.isEmpty()) {
                throwableCollector.execute(this::beforeAllMethods);
                if (throwableCollector.isEmpty()) {
                    this.execute();
                }
                throwableCollector.execute(this::afterAllMethods);
            }
            throwableCollector.execute(this::clearRandomFields);
        }
        throwableCollector.execute(this::clearArgumentFields);
        this.getStopWatch().stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoseconds());
        if (this.getThrowableCollector().isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.PASS);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.FAIL);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.getThrowableCollector().getThrowable()));
        }
    }

    private void setArgumentFields() throws Throwable {
        LOGGER.trace("setArgumentFields() testClass [%s] testInstance [%s] testArgument [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance(), this.testArgument);
        ArgumentAnnotationSupport.setArgumentFields(this.getTestInstance(), this.testArgument);
    }

    private void setRandomFields() throws Throwable {
        LOGGER.trace("setRandomFields() testClass [%s] testInstance [%s] testArgument [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance(), this.testArgument);
        RandomAnnotationSupport.setRandomFields(this.getTestInstance());
    }

    private void beforeAllMethods() throws Throwable {
        LOGGER.trace("beforeAllMethods() testClass [%s] testInstance [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance());
        for (Method method : this.beforeAllMethods) {
            LOGGER.trace("beforeAllMethods() testClass [%s] testInstance [%s] method [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance(), method);
            method.invoke(this.getTestInstance(), new Object[0]);
        }
    }

    private void execute() {
        LOGGER.trace("execute() testClass [%s] testInstance [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance());
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).execute(this.getExecutionRequest());
            }
        });
    }

    private void afterAllMethods() throws Throwable {
        LOGGER.trace("afterAllMethods() testClass [%s] testInstance [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance());
        for (Method method : this.afterAllMethods) {
            LOGGER.trace("afterAllMethods() testClass [%s] testInstance [%s] method [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance(), method);
            method.invoke(this.getTestInstance(), new Object[0]);
        }
    }

    private void clearRandomFields() throws Throwable {
        LOGGER.trace("clearRandomFields() testClass [%s] testInstance [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance());
        RandomAnnotationSupport.clearRandomFields(this.getTestInstance());
    }

    private void clearArgumentFields() throws Throwable {
        LOGGER.trace("clearArgumentFields() testClass [%s] testInstance [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance());
        ArgumentAnnotationSupport.setArgumentFields(this.getTestInstance(), null);
    }

    public static ArgumentTestDescriptor of(UniqueId parentUniqueId, Class<?> testClass, Argument<?> testArgument, int testArgumentIndex) {
        Preconditions.notNull((Object)parentUniqueId, (String)"parentUniqueId is null");
        Preconditions.notNull(testClass, (String)"testClass is null");
        Preconditions.notNull(testArgument, (String)"testArgument is null");
        UniqueId uniqueId = parentUniqueId.append(ArgumentTestDescriptor.class.getName(), testArgumentIndex + "/" + testArgument.getName());
        LOGGER.trace("uniqueId [%s]", (Object)uniqueId);
        String displayName = testArgument.getName();
        LOGGER.trace("displayName [%s]", (Object)displayName);
        List<Method> beforeAllMethods = ReflectionSupport.findMethods(testClass, Predicates.BEFORE_ALL_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        if (!beforeAllMethods.isEmpty() && LOGGER.isTraceEnabled()) {
            beforeAllMethods.forEach(method -> LOGGER.trace("beforeAll method [%s]", method));
        }
        beforeAllMethods = OrdererSupport.orderTestMethods(beforeAllMethods, HierarchyTraversalMode.TOP_DOWN);
        List<Method> afterAllMethods = ReflectionSupport.findMethods(testClass, Predicates.AFTER_ALL_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        if (!afterAllMethods.isEmpty() && LOGGER.isTraceEnabled()) {
            afterAllMethods.forEach(method -> LOGGER.trace("afterAll method [%s]", method));
        }
        afterAllMethods = OrdererSupport.orderTestMethods(afterAllMethods, HierarchyTraversalMode.BOTTOM_UP);
        return new ArgumentTestDescriptor(uniqueId, displayName, testClass, testArgument, beforeAllMethods, afterAllMethods);
    }
}

