/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.antublue.test.engine.internal.support.TagSupport;
import org.antublue.test.engine.internal.util.Predicates;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class EngineDiscoveryRequestResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineDiscoveryRequestResolver.class);
    private static final Configuration CONFIGURATION = Configuration.getInstance();

    public void resolveSelector(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) throws Throwable {
        List<Class<?>> testClasses = EngineDiscoveryRequestResolver.resolveEngineDiscoveryRequest(engineDiscoveryRequest);
        this.filterTestClassesByClassName(testClasses);
        this.filterTestClassesByTags(testClasses);
        OrdererSupport.orderTestClasses(testClasses);
        if (LOGGER.isTraceEnabled()) {
            testClasses.forEach(c -> LOGGER.trace("testClass [%s]", (Object)c.getName()));
        }
        for (Class<?> testClass : testClasses) {
            EngineDiscoveryRequestResolver.buildClassTestDescriptor(testClass, (TestDescriptor)engineDescriptor);
        }
        EngineDiscoveryRequestResolver.prune((TestDescriptor)engineDescriptor);
        EngineDiscoveryRequestResolver.shuffleOrSortTestDescriptors(engineDescriptor);
    }

    private static void buildClassTestDescriptor(Class<?> testClass, TestDescriptor parentTestDescriptor) throws Throwable {
        LOGGER.trace("buildClassTestDescriptor() testClass [%s]", (Object)testClass.getName());
        ClassTestDescriptor classTestDescriptor = ClassTestDescriptor.of(parentTestDescriptor.getUniqueId(), testClass);
        parentTestDescriptor.addChild((TestDescriptor)classTestDescriptor);
        int testArgumentIndex = 0;
        List<Argument<?>> testArguments = EngineDiscoveryRequestResolver.getArguments(testClass);
        for (Argument<?> testArgument : testArguments) {
            EngineDiscoveryRequestResolver.buildArgumentTestDescriptor(testClass, testArgument, testArgumentIndex, (TestDescriptor)classTestDescriptor);
            ++testArgumentIndex;
        }
    }

    private static void buildArgumentTestDescriptor(Class<?> testClass, Argument<?> testArgument, int testArgumentIndex, TestDescriptor parentTestDescriptor) {
        LOGGER.trace("buildArgumentTestDescriptor() testClass [%s] testArgument [%s] testArgumentIndex", testClass.getName(), testArgument.getName(), testArgumentIndex);
        ArgumentTestDescriptor argumentTestDescriptor = ArgumentTestDescriptor.of(parentTestDescriptor.getUniqueId(), testClass, testArgument, testArgumentIndex);
        parentTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
        EngineDiscoveryRequestResolver.buildMethodTestDescriptor(testClass, testArgument, (TestDescriptor)argumentTestDescriptor);
    }

    public static void buildMethodTestDescriptor(Class<?> testClass, Argument<?> testArgument, TestDescriptor parentTestDescriptor) {
        LOGGER.trace("buildMethodTestDescriptor() testClass [%s] testArgument [%s]", testClass.getName(), testArgument.getName());
        List<Method> testMethods = ReflectionSupport.findMethods(testClass, Predicates.TEST_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        testMethods = OrdererSupport.orderTestMethods(testMethods, HierarchyTraversalMode.TOP_DOWN);
        EngineDiscoveryRequestResolver.filterTestMethodsByMethodName(testMethods);
        EngineDiscoveryRequestResolver.filterTestMethodsByTags(testMethods);
        for (Method testMethod : testMethods) {
            MethodTestDescriptor methodTestDescriptor = MethodTestDescriptor.of(parentTestDescriptor.getUniqueId(), testClass, testMethod, testArgument);
            parentTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
        }
    }

    private static List<Class<?>> resolveEngineDiscoveryRequest(EngineDiscoveryRequest engineDiscoveryRequest) throws Throwable {
        Class javaClass;
        HashSet testClassSet = new HashSet();
        Predicate predicate = null;
        List discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            ClasspathRootSelector classpathRootSelector = (ClasspathRootSelector)discoverySelector;
            List javaClasses = ReflectionSupport.findAllClassesInClasspathRoot((URI)classpathRootSelector.getClasspathRoot(), Predicates.TEST_CLASS, className -> true);
            for (Class<?> javaClass2 : javaClasses) {
                if (predicate == null) {
                    ArrayList filters = new ArrayList();
                    filters.addAll(engineDiscoveryRequest.getFiltersByType(ClassNameFilter.class));
                    filters.addAll(engineDiscoveryRequest.getFiltersByType(PackageNameFilter.class));
                    predicate = Filter.composeFilters(filters).toPredicate();
                }
                if (!predicate.test(javaClass2.getPackage().getName())) continue;
                testClassSet.add(javaClass2);
            }
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(PackageSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            PackageSelector packageSelector = (PackageSelector)discoverySelector;
            String packageName = packageSelector.getPackageName();
            List javaClasses = ReflectionSupport.findAllClassesInPackage((String)packageName, Predicates.TEST_CLASS, p -> true);
            testClassSet.addAll(javaClasses);
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClassSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            ClassSelector classSelector = (ClassSelector)discoverySelector;
            javaClass = classSelector.getJavaClass();
            if (!Predicates.TEST_CLASS.test(javaClass)) continue;
            testClassSet.add(javaClass);
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(MethodSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            MethodSelector methodSelector = (MethodSelector)discoverySelector;
            javaClass = methodSelector.getJavaClass();
            Method javaMethod = methodSelector.getJavaMethod();
            if (!Predicates.TEST_CLASS.test(javaClass) || !Predicates.TEST_METHOD.test(javaMethod)) continue;
            testClassSet.add(javaClass);
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            Class<?> javaClass2;
            UniqueIdSelector uniqueIdSelector = (UniqueIdSelector)discoverySelector;
            UniqueId uniqueId = uniqueIdSelector.getUniqueId();
            List segments = uniqueId.getSegments();
            javaClass2 = null;
            for (UniqueId.Segment segment : segments) {
                String segmentType = segment.getType();
                if (!segmentType.equals(ClassTestDescriptor.class.getName())) continue;
                String javaClassName = segment.getValue();
                javaClass2 = Thread.currentThread().getContextClassLoader().loadClass(javaClassName);
            }
            if (javaClass2 == null) continue;
            testClassSet.add(javaClass2);
        }
        ArrayList testClassList = new ArrayList(testClassSet);
        testClassList.sort(Comparator.comparing(Class::getName));
        return testClassList;
    }

    private static Method getArumentSupplierMethod(Class<?> testClass) {
        List methods = ReflectionSupport.findMethods(testClass, Predicates.ARGUMENT_SUPPLIER_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        return (Method)methods.get(0);
    }

    private static List<Argument<?>> getArguments(Class<?> testClass) throws Throwable {
        Iterator iterator;
        ArrayList testArguments = new ArrayList();
        Object object = EngineDiscoveryRequestResolver.getArumentSupplierMethod(testClass).invoke(null, (Object[])null);
        if (object == null) {
            return testArguments;
        }
        if (!(object instanceof Stream) && !(object instanceof Iterable)) {
            throw new TestClassDefinitionException(String.format("testClass [%s] @TestEngine.ArgumentSupplier must return a Stream<Argument> or Iterable<Argument>, type returned [%s]", testClass.getName(), object.getClass().getName()));
        }
        if (object instanceof Stream) {
            Stream stream = (Stream)object;
            iterator = stream.iterator();
        } else {
            Iterable iterable = (Iterable)object;
            iterator = iterable.iterator();
        }
        long index = 0L;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof Argument) {
                testArguments.add((Argument)o);
            } else {
                testArguments.add(Argument.of((String)("[" + index + "]"), o));
            }
            ++index;
        }
        return testArguments;
    }

    private void filterTestClassesByClassName(List<Class<?>> testClasses) {
        Class<?> clazz;
        Iterator<Class<?>> iterator;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestClassesByName()");
        Optional<String> optional = CONFIGURATION.getProperty("antublue.test.engine.test.class.include.regex");
        if (optional.isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                matcher.reset(clazz.getName());
                if (matcher.find()) continue;
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.getProperty("antublue.test.engine.test.class.exclude.regex")).isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                matcher.reset(clazz.getName());
                if (!matcher.find()) continue;
                iterator.remove();
            }
        }
    }

    private void filterTestClassesByTags(List<Class<?>> testClasses) {
        String tag;
        Class<?> clazz;
        Iterator<Class<?>> iterator;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestClassesByTags()");
        Optional<String> optional = CONFIGURATION.getProperty("antublue.test.engine.test.class.tag.include.regex");
        if (optional.isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                tag = TagSupport.getTag(clazz);
                if (tag == null) {
                    iterator.remove();
                    continue;
                }
                matcher.reset(tag);
                if (matcher.find()) continue;
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.getProperty("antublue.test.engine.test.class.tag.exclude.regex")).isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                tag = TagSupport.getTag(clazz);
                if (tag == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                iterator.remove();
            }
        }
    }

    private static void filterTestMethodsByMethodName(List<Method> testMethods) {
        Method testMethod;
        Iterator<Method> iterator;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestMethodsByMethodName()");
        Optional<String> optional = CONFIGURATION.getProperty("antublue.test.engine.test.method.include.regex");
        if (optional.isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                matcher.reset(DisplayNameSupport.getDisplayName(testMethod));
                if (matcher.find()) continue;
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.getProperty("antublue.test.engine.test.method.exclude.regex")).isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                matcher.reset(DisplayNameSupport.getDisplayName(testMethod));
                if (!matcher.find()) continue;
                iterator.remove();
            }
        }
    }

    private static void filterTestMethodsByTags(List<Method> testMethods) {
        String tag;
        Method testMethod;
        Iterator<Method> iterator;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestMethodsByTag()");
        Optional<String> optional = CONFIGURATION.getProperty("antublue.test.engine.test.method.tag.include.regex");
        if (optional.isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                tag = TagSupport.getTag(testMethod);
                if (tag == null) {
                    iterator.remove();
                    continue;
                }
                matcher.reset(tag);
                if (matcher.find()) continue;
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.getProperty("antublue.test.engine.test.method.tag.exclude.regex")).isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                tag = TagSupport.getTag(testMethod);
                if (tag == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                iterator.remove();
            }
        }
    }

    private static void prune(TestDescriptor testDescriptor) {
        LinkedHashSet children = new LinkedHashSet(testDescriptor.getChildren());
        for (TestDescriptor child : children) {
            EngineDiscoveryRequestResolver.prune(child);
        }
        if (testDescriptor.isRoot()) {
            return;
        }
        if (testDescriptor.isContainer() && testDescriptor.getChildren().isEmpty()) {
            testDescriptor.removeFromHierarchy();
        }
    }

    private static void shuffleOrSortTestDescriptors(EngineDescriptor engineDescriptor) {
        ArrayList testDescriptors = new ArrayList(engineDescriptor.getChildren());
        testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).removeChild(arg_0));
        Optional<String> optionalShuffle = CONFIGURATION.getProperty("antublue.test.engine.test.class.shuffle");
        optionalShuffle.ifPresent(s -> {
            if ("true".equals(optionalShuffle.get())) {
                Collections.shuffle(testDescriptors);
            } else {
                testDescriptors.sort(Comparator.comparing(TestDescriptor::getDisplayName));
            }
        });
        testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).addChild(arg_0));
    }
}

