/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.extension;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.support.MethodSupport;
import org.antublue.test.engine.internal.support.ObjectSupport;
import org.antublue.test.engine.internal.util.Predicates;
import org.junit.platform.commons.support.HierarchyTraversalMode;

public class TestEngineExtension {
    private static Comparator<Method> ORDER_ANNOTATION_METHOD_COMPARATOR = new TestEngineOrderAnnotationMethodComparator();
    private final Class<?> clazz;
    private final List<Method> initializeMethods;
    private final List<Method> cleanupMethods;
    private Object object;

    private TestEngineExtension(Class<?> clazz, List<Method> initializeMethods, List<Method> cleanupMethods) {
        this.clazz = clazz;
        this.initializeMethods = initializeMethods;
        this.cleanupMethods = cleanupMethods;
    }

    public void initialize() throws Throwable {
        if (this.object == null) {
            this.object = ObjectSupport.createObject(this.clazz);
        }
        for (Method method : this.initializeMethods) {
            method.invoke(this.object, new Object[0]);
        }
    }

    public void cleanup() throws Throwable {
        for (Method method : this.cleanupMethods) {
            method.invoke(this.object, new Object[0]);
        }
    }

    public static TestEngineExtension createExtension(Class<?> clazz) {
        List<Method> initializeMethods = MethodSupport.getMethods(clazz, Predicates.ENGINE_EXTENSION_INITIALIZE_METHOD, HierarchyTraversalMode.TOP_DOWN);
        initializeMethods.sort(Comparator.comparing(Method::getName));
        initializeMethods.sort(ORDER_ANNOTATION_METHOD_COMPARATOR);
        List<Method> cleanupMethods = MethodSupport.getMethods(clazz, Predicates.ENGINE_EXTENSION_CLEANUP_METHOD, HierarchyTraversalMode.BOTTOM_UP);
        cleanupMethods.sort(Comparator.comparing(Method::getName));
        cleanupMethods.sort(ORDER_ANNOTATION_METHOD_COMPARATOR);
        Collections.reverse(cleanupMethods);
        return new TestEngineExtension(clazz, initializeMethods, cleanupMethods);
    }

    private static class TestEngineOrderAnnotationMethodComparator
    implements Comparator<Method> {
        private static final int DEFAULT_ORDER = Integer.MAX_VALUE;

        private TestEngineOrderAnnotationMethodComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            int o1Order = Integer.MAX_VALUE;
            TestEngine.Order o1Annotation = o1.getAnnotation(TestEngine.Order.class);
            if (o1Annotation != null) {
                o1Order = o1Annotation.order();
            }
            int o2Order = Integer.MAX_VALUE;
            TestEngine.Order o2Annotation = o2.getAnnotation(TestEngine.Order.class);
            if (o2Annotation != null) {
                o2Order = o2Annotation.order();
            }
            return Integer.compare(o1Order, o2Order);
        }
    }
}

