/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.logger;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.logger.Level;

public class Logger {
    private static final Configuration CONFIGURATION = Configuration.getInstance();
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd | HH:mm:ss.SSS", Locale.getDefault());
    private final String name;
    private Level level;

    Logger(String name) {
        this.name = name;
        this.level = Level.INFO;
        String loggerLevel = CONFIGURATION.getProperty("antublue.test.engine.logger.level").orElse(Level.INFO.toString());
        String regex = CONFIGURATION.getProperty("antublue.test.engine.logger.regex").orElse(".*");
        try {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(name);
            if (matcher.find()) {
                this.level = Level.toLevel(loggerLevel, Level.INFO);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isTraceEnabled() {
        return this.level.toInt() >= Level.TRACE.toInt();
    }

    public boolean isDebugEnabled() {
        return this.level.toInt() >= Level.DEBUG.toInt();
    }

    public boolean isInfoEnabled() {
        return this.level.toInt() >= Level.INFO.toInt();
    }

    public boolean isWarnEnabled() {
        return this.level.toInt() >= Level.WARN.toInt();
    }

    public boolean isErrorEnabled() {
        return this.level.toInt() >= Level.ERROR.toInt();
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        }
    }

    public boolean isEnabled(Level level) {
        return this.level.toInt() >= level.toInt();
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.log(System.out, this.createMessage(Level.TRACE, message));
        }
    }

    public void trace(String format, Object object) {
        if (this.isTraceEnabled()) {
            this.trace(format, new Object[]{object});
        }
    }

    public void trace(String format, Object ... objects) {
        if (this.isTraceEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.TRACE, String.format(format, objects)));
        }
    }

    public void trace(String message, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.log(System.out, this.createMessage(Level.TRACE, this.createMessage(message, throwable)));
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log(System.out, this.createMessage(Level.DEBUG, message));
        }
    }

    public void debug(String format, Object object) {
        if (this.isDebugEnabled()) {
            this.debug(format, new Object[]{object});
        }
    }

    public void debug(String format, Object ... objects) {
        if (this.isDebugEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.DEBUG, String.format(format, objects)));
        }
    }

    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log(System.out, this.createMessage(Level.DEBUG, this.createMessage(message, throwable)));
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.log(System.out, this.createMessage(Level.INFO, message));
        }
    }

    public void info(String format, Object object) {
        if (this.isInfoEnabled()) {
            this.info(format, new Object[]{object});
        }
    }

    public void info(String format, Object ... objects) {
        if (this.isInfoEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.INFO, String.format(format, objects)));
        }
    }

    public void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log(System.out, this.createMessage(Level.INFO, this.createMessage(message, throwable)));
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.log(System.out, this.createMessage(Level.WARN, message));
        }
    }

    public void warn(String format, Object object) {
        if (this.isWarnEnabled()) {
            this.warn(format, new Object[]{object});
        }
    }

    public void warn(String format, Object ... objects) {
        if (this.isWarnEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.WARN, String.format(format, objects)));
        }
    }

    public void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.log(System.out, this.createMessage(Level.WARN, this.createMessage(message, throwable)));
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.log(System.err, this.createMessage(Level.ERROR, message));
        }
    }

    public void error(String format, Object object) {
        if (this.isErrorEnabled()) {
            this.error(format, new Object[]{object});
        }
    }

    public void error(String format, Object ... objects) {
        if (this.isErrorEnabled()) {
            Objects.requireNonNull(format);
            this.log(System.out, this.createMessage(Level.ERROR, String.format(format, objects)));
        }
    }

    public void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.log(System.out, this.createMessage(Level.ERROR, this.createMessage(message, throwable)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createMessage(Level level, String message) {
        String dateTime;
        SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            dateTime = SIMPLE_DATE_FORMAT.format(new Date());
        }
        return dateTime + " | " + Thread.currentThread().getName() + " | " + level.toString() + " | " + this.name + " | " + message + " ";
    }

    private String createMessage(String message, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            printWriter.println(message);
            if (throwable != null) {
                throwable.printStackTrace(printWriter);
            }
        }
        return stringWriter.toString();
    }

    private void log(PrintStream printStream, String message) {
        printStream.println(message);
        printStream.flush();
    }
}

