/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.logger;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.logger.Logger;

public final class LoggerFactory {
    private final Map<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    private LoggerFactory() {
    }

    private Logger createLogger(String name) {
        return this.loggerMap.computeIfAbsent(name, Logger::new);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Configuration configuration = Configuration.getInstance();
        synchronized (configuration) {
            return SingletonHolder.INSTANCE.createLogger(name);
        }
    }

    private static final class SingletonHolder {
        private static final LoggerFactory INSTANCE = new LoggerFactory();

        private SingletonHolder() {
        }
    }
}

