/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.antublue.test.engine.Information;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.Executor;
import org.antublue.test.engine.internal.configuration.ConfigurationParameters;
import org.antublue.test.engine.internal.discovery.EngineDiscoveryRequestResolver;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.OrdererUtils;
import org.antublue.test.engine.internal.util.Predicates;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class TestEngine
implements org.junit.platform.engine.TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngine.class);
    public static final String ENGINE_ID = "antublue-test-engine";
    public static final String GROUP_ID = "org.antublue";
    public static final String ARTIFACT_ID = "test-engine";
    public static final String VERSION = Information.getInstance().getVersion();

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        LOGGER.trace("discover(" + uniqueId + ")");
        try {
            EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, this.getId());
            new EngineDiscoveryRequestResolver().resolveSelector(engineDiscoveryRequest, engineDescriptor);
            return engineDescriptor;
        }
        catch (TestClassDefinitionException | TestEngineException t) {
            if ("true".equals(System.getProperty("antublue.test.engine.maven.plugin"))) {
                throw t;
            }
            t.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Throwable t) {
            throw new TestEngineException("General exception", t);
        }
        return null;
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute() rootTestDescriptor children [%d]", (Object)executionRequest.getRootTestDescriptor().getChildren().size());
        if (executionRequest.getRootTestDescriptor().getChildren().isEmpty()) {
            return;
        }
        executionRequest.getEngineExecutionListener().executionStarted(executionRequest.getRootTestDescriptor());
        LinkedHashSet lifeCycleInstances = new LinkedHashSet();
        LinkedHashMap lifeCyclePrepareMethods = new LinkedHashMap();
        LinkedHashMap lifeCycleConcludeMethods = new LinkedHashMap();
        ThrowableCollector throwableCollector = new ThrowableCollector(throwable -> true);
        throwableCollector.execute(() -> {
            LinkedHashSet lifeCycleClasses = new LinkedHashSet();
            for (URI uri : TestEngine.getClasspathURIs()) {
                lifeCycleClasses.addAll(ReflectionSupport.findAllClassesInClasspathRoot((URI)uri, Predicates.LIFE_CYCLE_CLASS, s -> true));
            }
            for (Class lifecyleClass : lifeCycleClasses) {
                Object lifeCycleInstance = lifecyleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                lifeCycleInstances.add(lifeCycleInstance);
                List<Method> prepareMethods = ReflectionSupport.findMethods((Class)lifecyleClass, Predicates.PREPARE_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                prepareMethods = OrdererUtils.orderTestMethods(prepareMethods, HierarchyTraversalMode.TOP_DOWN);
                lifeCyclePrepareMethods.put(lifeCycleInstance, prepareMethods);
                List<Method> concludeMethods = ReflectionSupport.findMethods((Class)lifecyleClass, Predicates.CONCLUDE_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
                concludeMethods = OrdererUtils.orderTestMethods(concludeMethods, HierarchyTraversalMode.BOTTOM_UP);
                lifeCycleConcludeMethods.put(lifeCycleInstance, concludeMethods);
            }
        });
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                for (Object lifeCycleInstance : lifeCycleInstances) {
                    for (Method lifeCyclePrepareMethod : (List)lifeCyclePrepareMethods.get(lifeCycleInstance)) {
                        lifeCyclePrepareMethod.invoke(lifeCycleInstance, new Object[0]);
                    }
                }
            });
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                Executor executor = new Executor();
                executor.execute(ExecutionRequest.create((TestDescriptor)executionRequest.getRootTestDescriptor(), (EngineExecutionListener)executionRequest.getEngineExecutionListener(), (org.junit.platform.engine.ConfigurationParameters)ConfigurationParameters.getInstance()));
                executor.await();
            });
        }
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (Object lifeCycleInstance : lifeCycleInstances) {
            for (Method lifeCycleConcludeMethod : (List)lifeCycleConcludeMethods.get(lifeCycleInstance)) {
                try {
                    lifeCycleConcludeMethod.invoke(lifeCycleInstance, new Object[0]);
                }
                catch (Throwable t) {
                    throwables.add(t);
                }
            }
        }
        StandardStreams.flush();
        if (throwableCollector.isEmpty() && throwables.isEmpty()) {
            executionRequest.getEngineExecutionListener().executionFinished(executionRequest.getRootTestDescriptor(), TestExecutionResult.successful());
        } else {
            Throwable throwable2 = throwableCollector.isNotEmpty() ? throwableCollector.getThrowable() : (Throwable)throwables.get(0);
            executionRequest.getEngineExecutionListener().executionFinished(executionRequest.getRootTestDescriptor(), TestExecutionResult.failed((Throwable)throwable2));
        }
    }

    private static Set<URI> getClasspathURIs() {
        String[] paths;
        LOGGER.trace("getClasspathURIs()");
        String classpath = System.getProperty("java.class.path");
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (String path : paths = classpath.split(File.pathSeparator)) {
            try {
                URI uri = new File(path).toURI();
                uris.add(uri);
            }
            catch (Exception e) {
                System.err.println("Error converting path to URI [" + path + "]");
                e.printStackTrace();
            }
        }
        return uris;
    }
}

