/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.configuration;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.antublue.test.engine.internal.logger.Level;

public class Configuration {
    public static final String ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE = "ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_ENVIRONMENT_VARIABLE = "ANTUBLUE_TEST_ENGINE_PROPERTIES";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_SYSTEM_PROPERTY = "antublue.test.engine.properties";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME_1 = "antublue-test-engine.properties";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME_2 = ".antublue-test-engine.properties";
    private static final boolean IS_TRACE_ENABLED = "true".equalsIgnoreCase(System.getenv("ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE"));
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd | HH:mm:ss.SSS", Locale.getDefault());
    private String propertiesFilename;
    private final Properties properties;
    private Set<String> keySet;

    private Configuration() {
        File propertiesFile;
        this.trace("ConfigurationImpl()", new Object[0]);
        this.properties = new Properties();
        String value = System.getenv(ANTUBLUE_TEST_ENGINE_PROPERTIES_ENVIRONMENT_VARIABLE);
        if (value != null && !value.trim().isEmpty()) {
            this.propertiesFilename = value.trim();
        }
        if (this.propertiesFilename == null && (value = System.getProperty(ANTUBLUE_TEST_ENGINE_PROPERTIES_SYSTEM_PROPERTY)) != null && !value.trim().isEmpty()) {
            this.propertiesFilename = value.trim();
        }
        if ((propertiesFile = this.find(Paths.get(".", new String[0]), ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME_1)) == null) {
            propertiesFile = this.find(Paths.get(".", new String[0]), ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME_2);
        }
        if (propertiesFile != null) {
            this.propertiesFilename = propertiesFile.getAbsolutePath();
            this.trace("loading properties [%s]", this.propertiesFilename);
            try (FileReader reader = new FileReader(propertiesFile);){
                this.properties.load(reader);
                TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
                for (Object key : this.properties.keySet()) {
                    map.put((String)key, true);
                }
                this.keySet = map.keySet();
                this.trace("properties loaded [%s]", this.propertiesFilename);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.keySet == null) {
            this.keySet = new LinkedHashSet<String>();
        }
    }

    public static Configuration getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Optional<String> getProperty(String key) {
        String value = this.properties.getProperty(key);
        this.trace("getProperty [%s] value [%s]", key, value);
        return Optional.ofNullable(value);
    }

    public <T> Optional<T> getProperty(String key, Function<String, T> transformer) {
        Optional<String> optional = this.getProperty(key);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        String value = optional.get();
        return Optional.ofNullable(transformer.apply(value));
    }

    public Set<String> getPropertyNames() {
        return this.keySet;
    }

    public Set<String> getPropertyNames(Predicate<String> predicate) {
        if (predicate == null) {
            return this.getPropertyNames();
        }
        HashSet<String> keySet = new HashSet<String>();
        for (String key : this.keySet) {
            if (!predicate.test(key)) continue;
            keySet.add(key);
        }
        return keySet;
    }

    public String getPropertiesFilename() {
        return this.propertiesFilename;
    }

    public int size() {
        return this.properties.size();
    }

    private void trace(String format, Object ... objects) {
        if (IS_TRACE_ENABLED) {
            System.out.println(this.createMessage(Level.TRACE, String.format(format, objects)));
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createMessage(Level level, String message) {
        String dateTime;
        SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            dateTime = SIMPLE_DATE_FORMAT.format(new Date());
        }
        return dateTime + " | " + Thread.currentThread().getName() + " | " + level.toString() + " | " + Configuration.class.getName() + " | " + message + " ";
    }

    private File find(Path path, String filename) {
        Path currentPath = path.toAbsolutePath().normalize();
        while (true) {
            this.trace("searching path [%s]", currentPath);
            File propertiesFile = new File(currentPath.toAbsolutePath() + File.separator + filename);
            if (propertiesFile.exists() && propertiesFile.isFile() && propertiesFile.canRead()) {
                return propertiesFile;
            }
            if ((currentPath = currentPath.getParent()) == null) break;
            currentPath = currentPath.toAbsolutePath().normalize();
        }
        return null;
    }

    private static final class SingletonHolder {
        private static final Configuration INSTANCE = new Configuration();

        private SingletonHolder() {
        }
    }
}

