/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.internal.MetadataConstants;
import org.antublue.test.engine.internal.annotation.RandomAnnotationUtils;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.DisplayNameUtils;
import org.antublue.test.engine.internal.util.OrdererUtils;
import org.antublue.test.engine.internal.util.Predicates;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class ClassTestDescriptor
extends ExecutableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassTestDescriptor.class);
    private final Class<?> testClass;
    private final List<Method> prepareMethods;
    private final List<Method> concludeMethods;

    private ClassTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, List<Method> prepareMethods, List<Method> concludeMethods) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.prepareMethods = prepareMethods;
        this.concludeMethods = concludeMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public String getTag() {
        return ClassTestDescriptor.getTag(this.testClass);
    }

    @Override
    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute(ExecutionRequest executionRequest)");
        this.getStopWatch().reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getDisplayName());
        this.setExecutionRequest(executionRequest);
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        throwableCollector.execute(this::setRandomFields);
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(this::createTestInstance);
            if (throwableCollector.isEmpty()) {
                throwableCollector.execute(this::prepare);
                if (throwableCollector.isEmpty()) {
                    this.execute();
                } else {
                    this.skip(executionRequest);
                }
                throwableCollector.execute(this::conclude);
            }
            throwableCollector.execute(this::destroyTestInstance);
        }
        throwableCollector.execute(this::clearRandomFields);
        this.getStopWatch().stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoseconds());
        if (this.getThrowableCollector().isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.PASS);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.FAIL);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.getThrowableCollector().getThrowable()));
        }
        StandardStreams.flush();
    }

    private void setRandomFields() throws Throwable {
        LOGGER.trace("setRandomFields() testClass [%s]", (Object)this.getTestClass().getName());
        RandomAnnotationUtils.injectRandomFields(this.getTestClass());
    }

    private void prepare() throws Throwable {
        LOGGER.trace("prepare() testClass [%s] testInstance [%s]", this.getTestClass().getName(), this.getTestInstance());
        for (Method method : this.prepareMethods) {
            LOGGER.trace("prepare() testClass [%s] testInstance [%s] method [%s]", this.getTestClass().getName(), this.getTestInstance(), method);
            method.invoke(this.getTestInstance(), new Object[0]);
        }
    }

    private void createTestInstance() throws Throwable {
        LOGGER.trace("createTestInstance() testClass [%s]", (Object)this.getTestClass().getName());
        this.setTestInstance(this.getTestClass().getDeclaredConstructor(null).newInstance(null));
        LOGGER.trace("createTestInstance() testClass [%s] testInstance [%s]", this.getTestClass().getName(), this.getTestInstance());
    }

    private void execute() {
        LOGGER.trace("execute() testClass [%s]", (Object)this.getTestClass().getName());
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).execute(this.getExecutionRequest());
            }
        });
    }

    private void clearRandomFields() throws Throwable {
        LOGGER.trace("clearRandomFields() testClass [%s]", (Object)this.getTestClass().getName());
        RandomAnnotationUtils.clearRandomFields(this.getTestClass());
    }

    private void conclude() throws Throwable {
        LOGGER.trace("conclude() testClass [%s] testInstance [%s]", this.getTestClass().getName(), this.getTestInstance());
        for (Method method : this.concludeMethods) {
            LOGGER.trace("conclude() testClass [%s] testInstance [%s] method [%s]", this.getTestClass().getName(), this.getTestInstance(), method);
            method.invoke(this.getTestInstance(), new Object[0]);
        }
    }

    private void destroyTestInstance() {
        LOGGER.trace("destroyTestInstance() testClass [%s]", this.getTestClass().getName(), this.getTestInstance());
        this.setTestInstance(null);
    }

    public static ClassTestDescriptor of(UniqueId parentUniqueId, Class<?> testClass) {
        UniqueId uniqueId = parentUniqueId.append(ClassTestDescriptor.class.getName(), testClass.getName());
        LOGGER.trace("uniqueId [%s]", (Object)uniqueId);
        String displayName = DisplayNameUtils.getDisplayName(testClass);
        LOGGER.trace("displayName [%s]", (Object)displayName);
        List<Method> prepareMethods = ReflectionSupport.findMethods(testClass, Predicates.PREPARE_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        prepareMethods = OrdererUtils.orderTestMethods(prepareMethods, HierarchyTraversalMode.TOP_DOWN);
        if (!prepareMethods.isEmpty() && LOGGER.isTraceEnabled()) {
            prepareMethods.forEach(method -> LOGGER.trace("prepare method [%s]", method));
        }
        List<Method> concludeMethods = ReflectionSupport.findMethods(testClass, Predicates.CONCLUDE_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        if (!(concludeMethods = OrdererUtils.orderTestMethods(concludeMethods, HierarchyTraversalMode.TOP_DOWN)).isEmpty() && LOGGER.isTraceEnabled()) {
            concludeMethods.forEach(method -> LOGGER.trace("conclude method [%s]", method));
        }
        return new ClassTestDescriptor(uniqueId, displayName, testClass, prepareMethods, concludeMethods);
    }
}

