/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.internal.MetadataConstants;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.DisplayNameUtils;
import org.antublue.test.engine.internal.util.OrdererUtils;
import org.antublue.test.engine.internal.util.Predicates;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class MethodTestDescriptor
extends ExecutableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodTestDescriptor.class);
    private final Class<?> testClass;
    private final List<Method> beforeEachMethods;
    private final Method testMethod;
    private final List<Method> afterEachMethods;

    public MethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, List<Method> beforeEachMethods, Method testMethod, List<Method> afterEachMethods) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.beforeEachMethods = beforeEachMethods;
        this.testMethod = testMethod;
        this.afterEachMethods = afterEachMethods;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public String getTag() {
        return MethodTestDescriptor.getTag(this.testMethod);
    }

    @Override
    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute(ExecutionRequest executionRequest)");
        this.getStopWatch().reset();
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        this.setExecutionRequest(executionRequest);
        Object testInstance = this.getParent(ExecutableTestDescriptor.class).getTestInstance();
        Preconditions.notNull((Object)testInstance, (String)"testInstance is null");
        this.setTestInstance(testInstance);
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", DisplayNameUtils.getDisplayName(this.testClass));
        this.getMetadata().put("testMethod", this.testMethod);
        this.getMetadata().put("testMethod.displayName", this.getDisplayName());
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        throwableCollector.execute(this::beforeEach);
        if (this.getThrowableCollector().isEmpty()) {
            throwableCollector.execute(this::test);
        }
        throwableCollector.execute(this::afterEach);
        this.setExecutionRequest(null);
        this.setTestInstance(null);
        this.getStopWatch().stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoseconds());
        if (this.getThrowableCollector().isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.PASS);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.FAIL);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.getThrowableCollector().getThrowable()));
        }
        StandardStreams.flush();
    }

    private void beforeEach() throws Throwable {
        LOGGER.trace("beforeEach() testClass [%s] testInstance [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance());
        for (Method method : this.beforeEachMethods) {
            LOGGER.trace("beforeEach() testClass [%s] testInstance [%s] method [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance(), method);
            method.invoke(this.getTestInstance(), new Object[0]);
            StandardStreams.flush();
        }
    }

    private void test() throws Throwable {
        LOGGER.trace("test() testClass [%s] testInstance [%s] method [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance(), this.getTestMethod());
        this.getTestMethod().invoke(this.getTestInstance(), new Object[0]);
        StandardStreams.flush();
    }

    private void afterEach() throws Throwable {
        LOGGER.trace("afterEach() testClass [%s] testInstance [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance());
        for (Method method : this.afterEachMethods) {
            LOGGER.trace("afterEach() testClass [%s] testInstance [%s] method [%s]", this.getTestInstance().getClass().getName(), this.getTestInstance(), method);
            method.invoke(this.getTestInstance(), new Object[0]);
            StandardStreams.flush();
        }
    }

    public static MethodTestDescriptor of(UniqueId parentUniqueId, Class<?> testClass, Method testMethod) {
        UniqueId uniqueId = parentUniqueId.append(MethodTestDescriptor.class.getName(), testMethod.getName());
        String displayName = DisplayNameUtils.getDisplayName(testMethod);
        List<Method> beforeEachMethods = ReflectionSupport.findMethods(testClass, Predicates.BEFORE_EACH_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        beforeEachMethods = OrdererUtils.orderTestMethods(beforeEachMethods, HierarchyTraversalMode.TOP_DOWN);
        List<Method> afterEachMethods = ReflectionSupport.findMethods(testClass, Predicates.AFTER_EACH_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        afterEachMethods = OrdererUtils.orderTestMethods(afterEachMethods, HierarchyTraversalMode.BOTTOM_UP);
        return new MethodTestDescriptor(uniqueId, displayName, testClass, beforeEachMethods, testMethod, afterEachMethods);
    }
}

