/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.OrdererUtils;
import org.antublue.test.engine.internal.util.Predicates;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class EngineDiscoveryRequestResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineDiscoveryRequestResolver.class);
    private static final Configuration CONFIGURATION = Configuration.getInstance();

    public void resolveSelector(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) throws Throwable {
        Set<Class<?>> testClasses = EngineDiscoveryRequestResolver.findTestClasses(engineDiscoveryRequest);
        if (LOGGER.isTraceEnabled()) {
            testClasses.forEach(aClass -> LOGGER.trace("testClass [%s]", (Object)aClass.getName()));
        }
        for (Class<?> testClass : testClasses) {
            EngineDiscoveryRequestResolver.buildClassTestDescriptor(testClass, (TestDescriptor)engineDescriptor);
        }
        EngineDiscoveryRequestResolver.filterTestClassesByClassName(engineDescriptor);
        EngineDiscoveryRequestResolver.filterTestClassesByTag(engineDescriptor);
        EngineDiscoveryRequestResolver.filterTestMethodsByMethodName(engineDescriptor);
        EngineDiscoveryRequestResolver.filterTestMethodsByTag(engineDescriptor);
        EngineDiscoveryRequestResolver.prune((TestDescriptor)engineDescriptor);
        EngineDiscoveryRequestResolver.shuffleOrSortTestDescriptors(engineDescriptor);
    }

    private static void buildClassTestDescriptor(Class<?> testClass, TestDescriptor parentTestDescriptor) throws Throwable {
        LOGGER.trace("buildClassTestDescriptor() testClass [%s]", (Object)testClass.getName());
        ClassTestDescriptor classTestDescriptor = ClassTestDescriptor.of(parentTestDescriptor.getUniqueId(), testClass);
        parentTestDescriptor.addChild((TestDescriptor)classTestDescriptor);
        int testArgumentIndex = 0;
        List<Argument<?>> testArguments = EngineDiscoveryRequestResolver.getArguments(testClass);
        for (Argument<?> testArgument : testArguments) {
            EngineDiscoveryRequestResolver.buildArgumentTestDescriptor(testClass, testArgument, testArgumentIndex, (TestDescriptor)classTestDescriptor);
            ++testArgumentIndex;
        }
    }

    private static void buildArgumentTestDescriptor(Class<?> testClass, Argument<?> testArgument, int testArgumentIndex, TestDescriptor parentTestDescriptor) {
        LOGGER.trace("buildArgumentTestDescriptor() testClass [%s] testArgument [%s] testArgumentIndex", testClass.getName(), testArgument.getName(), testArgumentIndex);
        ArgumentTestDescriptor argumentTestDescriptor = ArgumentTestDescriptor.of(parentTestDescriptor.getUniqueId(), testClass, testArgument, testArgumentIndex);
        parentTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
        EngineDiscoveryRequestResolver.buildMethodTestDescriptor(testClass, (TestDescriptor)argumentTestDescriptor);
    }

    public static void buildMethodTestDescriptor(Class<?> testClass, TestDescriptor parentTestDescriptor) {
        LOGGER.trace("buildMethodTestDescriptor() testClass [%s]", (Object)testClass.getName());
        List<Method> testMethods = ReflectionSupport.findMethods(testClass, Predicates.TEST_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        testMethods = OrdererUtils.orderTestMethods(testMethods, HierarchyTraversalMode.TOP_DOWN);
        for (Method testMethod : testMethods) {
            MethodTestDescriptor methodTestDescriptor = MethodTestDescriptor.of(parentTestDescriptor.getUniqueId(), testClass, testMethod);
            parentTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
        }
    }

    private static Set<Class<?>> findTestClasses(EngineDiscoveryRequest engineDiscoveryRequest) throws Throwable {
        Class javaClass;
        HashSet testClassSet = new HashSet();
        Predicate predicate = null;
        List discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            ClasspathRootSelector classpathRootSelector = (ClasspathRootSelector)discoverySelector;
            List javaClasses = ReflectionSupport.findAllClassesInClasspathRoot((URI)classpathRootSelector.getClasspathRoot(), Predicates.TEST_CLASS, className -> true);
            for (Class<?> javaClass2 : javaClasses) {
                if (predicate == null) {
                    ArrayList filters = new ArrayList();
                    filters.addAll(engineDiscoveryRequest.getFiltersByType(ClassNameFilter.class));
                    filters.addAll(engineDiscoveryRequest.getFiltersByType(PackageNameFilter.class));
                    predicate = Filter.composeFilters(filters).toPredicate();
                }
                if (!predicate.test(javaClass2.getPackage().getName())) continue;
                testClassSet.add(javaClass2);
            }
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(PackageSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            PackageSelector packageSelector = (PackageSelector)discoverySelector;
            String packageName = packageSelector.getPackageName();
            List javaClasses = ReflectionSupport.findAllClassesInPackage((String)packageName, Predicates.TEST_CLASS, p -> true);
            testClassSet.addAll(javaClasses);
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClassSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            ClassSelector classSelector = (ClassSelector)discoverySelector;
            javaClass = classSelector.getJavaClass();
            if (!Predicates.TEST_CLASS.test(javaClass)) continue;
            testClassSet.add(javaClass);
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(MethodSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            MethodSelector methodSelector = (MethodSelector)discoverySelector;
            javaClass = methodSelector.getJavaClass();
            Method javaMethod = methodSelector.getJavaMethod();
            if (!Predicates.TEST_CLASS.test(javaClass) || !Predicates.TEST_METHOD.test(javaMethod)) continue;
            testClassSet.add(javaClass);
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            Class<?> javaClass2;
            UniqueIdSelector uniqueIdSelector = (UniqueIdSelector)discoverySelector;
            UniqueId uniqueId = uniqueIdSelector.getUniqueId();
            List segments = uniqueId.getSegments();
            javaClass2 = null;
            for (UniqueId.Segment segment : segments) {
                String segmentType = segment.getType();
                if (!segmentType.equals(ClassTestDescriptor.class.getName())) continue;
                String javaClassName = segment.getValue();
                javaClass2 = Thread.currentThread().getContextClassLoader().loadClass(javaClassName);
            }
            if (javaClass2 == null) continue;
            testClassSet.add(javaClass2);
        }
        ArrayList<Class> testClassList = new ArrayList<Class>(testClassSet);
        testClassList.sort(Comparator.comparing(Class::getName));
        testClassSet = new LinkedHashSet(testClassList);
        return testClassSet;
    }

    private static Method getArumentSupplierMethod(Class<?> testClass) {
        List methods = ReflectionSupport.findMethods(testClass, Predicates.ARGUMENT_SUPPLIER_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        return (Method)methods.get(0);
    }

    private static List<Argument<?>> getArguments(Class<?> testClass) throws Throwable {
        Iterator iterator;
        ArrayList testArguments = new ArrayList();
        Object object = EngineDiscoveryRequestResolver.getArumentSupplierMethod(testClass).invoke(null, (Object[])null);
        if (!(object instanceof Stream) && !(object instanceof Iterable)) {
            throw new TestClassDefinitionException(String.format("Exception getting arguments for test class [%s]", testClass.getName()));
        }
        if (object instanceof Stream) {
            Stream stream = (Stream)object;
            iterator = stream.iterator();
        } else {
            Iterable iterable = (Iterable)object;
            iterator = iterable.iterator();
        }
        long index = 0L;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof Argument) {
                testArguments.add((Argument)o);
            } else {
                testArguments.add(Argument.of((String)("[" + index + "]"), o));
            }
            ++index;
        }
        return testArguments;
    }

    private static void filterTestClassesByClassName(EngineDescriptor engineDescriptor) {
        LOGGER.trace("filterTestClassesByClassName()");
        CONFIGURATION.getProperty("antublue.test.engine.test.class.include.regex").ifPresent(s -> {
            Pattern pattern = Pattern.compile(s);
            Matcher matcher = pattern.matcher("");
            LinkedHashSet children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof ClassTestDescriptor)) continue;
                ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)testDescriptor;
                matcher.reset(classTestDescriptor.getTestClass().getName());
                if (matcher.find()) continue;
                classTestDescriptor.removeFromHierarchy();
            }
        });
        CONFIGURATION.getProperty("antublue.test.engine.test.class.exclude.regex").ifPresent(s -> {
            Pattern pattern = Pattern.compile(s);
            Matcher matcher = pattern.matcher("");
            LinkedHashSet children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof ClassTestDescriptor)) continue;
                ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)testDescriptor;
                matcher.reset(classTestDescriptor.getTestClass().getName());
                if (!matcher.find()) continue;
                classTestDescriptor.removeFromHierarchy();
            }
        });
    }

    private static void filterTestClassesByTag(EngineDescriptor engineDescriptor) {
        LOGGER.trace("filterTestClassesByTag()");
        CONFIGURATION.getProperty("antublue.test.engine.test.class.tag.include.regex").ifPresent(s -> {
            Pattern pattern = Pattern.compile(s);
            Matcher matcher = pattern.matcher("");
            LinkedHashSet children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof ClassTestDescriptor)) continue;
                ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)testDescriptor;
                String tag = classTestDescriptor.getTag();
                if (tag != null) {
                    matcher.reset(tag);
                    if (matcher.find()) continue;
                    classTestDescriptor.removeFromHierarchy();
                    continue;
                }
                classTestDescriptor.removeFromHierarchy();
            }
        });
        CONFIGURATION.getProperty("antublue.test.engine.test.class.tag.exclude.regex").ifPresent(s -> {
            Pattern pattern = Pattern.compile(s);
            Matcher matcher = pattern.matcher("");
            LinkedHashSet children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                ClassTestDescriptor classTestDescriptor;
                String tag;
                if (!(testDescriptor instanceof ClassTestDescriptor) || (tag = (classTestDescriptor = (ClassTestDescriptor)testDescriptor).getTag()) == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                classTestDescriptor.removeFromHierarchy();
            }
        });
    }

    private static void filterTestMethodsByMethodName(EngineDescriptor engineDescriptor) {
        LOGGER.trace("filterTestMethodsByMethodName()");
        CONFIGURATION.getProperty("antublue.test.engine.test.method.include.regex").ifPresent(s -> {
            Pattern pattern = Pattern.compile(s);
            Matcher matcher = pattern.matcher("");
            LinkedHashSet children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof MethodTestDescriptor)) continue;
                MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                matcher.reset(methodTestDescriptor.getTestMethod().getName());
                if (matcher.find()) continue;
                methodTestDescriptor.removeFromHierarchy();
            }
        });
        CONFIGURATION.getProperty("antublue.test.engine.test.method.exclude.regex").ifPresent(s -> {
            Pattern pattern = Pattern.compile(s);
            Matcher matcher = pattern.matcher("");
            LinkedHashSet children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof MethodTestDescriptor)) continue;
                MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                matcher.reset(methodTestDescriptor.getTestMethod().getName());
                if (!matcher.find()) continue;
                methodTestDescriptor.removeFromHierarchy();
            }
        });
    }

    private static void filterTestMethodsByTag(EngineDescriptor engineDescriptor) {
        LOGGER.trace("filterTestMethodsByTag()");
        CONFIGURATION.getProperty("antublue.test.engine.test.method.tag.include.regex").ifPresent(s -> {
            Pattern pattern = Pattern.compile(s);
            Matcher matcher = pattern.matcher("");
            LinkedHashSet children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof MethodTestDescriptor)) continue;
                MethodTestDescriptor methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                String tag = methodTestDescriptor.getTag();
                if (tag != null) {
                    matcher.reset(tag);
                    if (matcher.find()) continue;
                    methodTestDescriptor.removeFromHierarchy();
                    continue;
                }
                methodTestDescriptor.removeFromHierarchy();
            }
        });
        CONFIGURATION.getProperty("antublue.test.engine.test.method.tag.exclude.regex").ifPresent(s -> {
            Pattern pattern = Pattern.compile(s);
            Matcher matcher = pattern.matcher("");
            LinkedHashSet children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                MethodTestDescriptor methodTestDescriptor;
                String tag;
                if (!(testDescriptor instanceof MethodTestDescriptor) || (tag = (methodTestDescriptor = (MethodTestDescriptor)testDescriptor).getTag()) == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                methodTestDescriptor.removeFromHierarchy();
            }
        });
    }

    private static void prune(TestDescriptor testDescriptor) {
        LinkedHashSet children = new LinkedHashSet(testDescriptor.getChildren());
        for (TestDescriptor child : children) {
            EngineDiscoveryRequestResolver.prune(child);
        }
        if (testDescriptor.isRoot()) {
            return;
        }
        if (testDescriptor.isContainer() && testDescriptor.getChildren().isEmpty()) {
            testDescriptor.removeFromHierarchy();
        }
    }

    private static void shuffleOrSortTestDescriptors(EngineDescriptor engineDescriptor) {
        ArrayList testDescriptors = new ArrayList(engineDescriptor.getChildren());
        testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).removeChild(arg_0));
        Optional<String> optionalShuffle = CONFIGURATION.getProperty("antublue.test.engine.test.class.shuffle");
        optionalShuffle.ifPresent(s -> {
            if ("true".equals(optionalShuffle.get())) {
                Collections.shuffle(testDescriptors);
            } else {
                testDescriptors.sort(Comparator.comparing(TestDescriptor::getDisplayName));
            }
        });
        testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).addChild(arg_0));
    }
}

