/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.Optional;
import org.antublue.test.engine.internal.metadata.Metadata;
import org.antublue.test.engine.internal.metadata.MetadataInformation;
import org.antublue.test.engine.internal.util.StopWatch;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public abstract class ExecutableTestDescriptor
extends AbstractTestDescriptor
implements Metadata {
    private final ThrowableCollector throwableCollector = new ThrowableCollector(throwable -> true);
    private final MetadataInformation metadataInformation = new MetadataInformation();
    private final StopWatch stopWatch = new StopWatch();

    protected ExecutableTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    public abstract void execute(ExecutionRequest var1, Object var2);

    public void skip(ExecutionRequest executionRequest, Object testInstance) {
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).skip(executionRequest, testInstance);
            }
        });
    }

    @Override
    public MetadataInformation getMetadata() {
        return this.metadataInformation;
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected <T> T getParent(Class<T> clazz) {
        Optional optional = this.getParent();
        Preconditions.condition((boolean)optional.isPresent(), (String)"parent is null");
        return clazz.cast(optional.get());
    }

    protected StopWatch getStopWatch() {
        return this.stopWatch;
    }

    protected ThrowableCollector getThrowableCollector() {
        return this.throwableCollector;
    }
}

