/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.support;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.support.FieldSupport;
import org.antublue.test.engine.internal.util.Predicates;
import org.antublue.test.engine.internal.util.RandomUtils;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;

public class RandomAnnotationSupport {
    private static final Predicate<Field> HAS_RANDOM_ANNOTATION = field -> field.isAnnotationPresent(TestEngine.Random.Boolean.class) || field.isAnnotationPresent(TestEngine.Random.Byte.class) || field.isAnnotationPresent(TestEngine.Random.Character.class) || field.isAnnotationPresent(TestEngine.Random.Short.class) || field.isAnnotationPresent(TestEngine.Random.Integer.class) || field.isAnnotationPresent(TestEngine.Random.Long.class) || field.isAnnotationPresent(TestEngine.Random.Float.class) || field.isAnnotationPresent(TestEngine.Random.Double.class) || field.isAnnotationPresent(TestEngine.Random.BigInteger.class) || field.isAnnotationPresent(TestEngine.Random.BigDecimal.class) || field.isAnnotationPresent(TestEngine.Random.UUID.class);

    private RandomAnnotationSupport() {
    }

    public static void setRandomFields(Class<?> testClass) throws Throwable {
        Preconditions.notNull(testClass, (String)"testClass is null");
        RandomAnnotationSupport.setRandomFields(testClass, null, Predicates.STATIC_FIELD);
    }

    public static void setRandomFields(Object testInstance) throws Throwable {
        Preconditions.notNull((Object)testInstance, (String)"testInstance is null");
        RandomAnnotationSupport.setRandomFields(testInstance.getClass(), testInstance, Predicates.FIELD);
    }

    public static void clearRandomFields(Class<?> testClass) throws Throwable {
        Preconditions.notNull(testClass, (String)"testClass is null");
        RandomAnnotationSupport.clearRandomFields(testClass, null, Predicates.STATIC_FIELD);
    }

    public static void clearRandomFields(Object testInstance) throws Throwable {
        Preconditions.notNull((Object)testInstance, (String)"testInstance is null");
        RandomAnnotationSupport.clearRandomFields(testInstance.getClass(), testInstance, Predicates.FIELD);
    }

    private static void setRandomFields(Class<?> testClass, Object testInstance, Predicate<Field> fieldPredicate) throws Throwable {
        List fields = ReflectionSupport.findFields(testClass, field -> fieldPredicate.test((Field)field) && HAS_RANDOM_ANNOTATION.test((Field)field), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field2 : fields) {
            TestEngine.Random.Byte annotation;
            if (field2.isAnnotationPresent(TestEngine.Random.Boolean.class)) {
                FieldSupport.setField(testInstance, field2, RandomUtils.randomBoolean());
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Byte.class)) {
                annotation = field2.getAnnotation(TestEngine.Random.Byte.class);
                byte minimum = annotation.minimum();
                byte maximum = annotation.maximum();
                byte random = (byte)RandomUtils.randomInt(minimum, maximum);
                FieldSupport.setField(testInstance, field2, random);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Character.class)) {
                annotation = field2.getAnnotation(TestEngine.Random.Character.class);
                char minimum = annotation.minimum();
                char maximum = annotation.maximum();
                char random = (char)RandomUtils.randomInt(minimum, maximum);
                FieldSupport.setField(testInstance, field2, Character.valueOf(random));
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Short.class)) {
                annotation = field2.getAnnotation(TestEngine.Random.Short.class);
                short minimum = annotation.minimum();
                short maximum = annotation.maximum();
                short random = (short)RandomUtils.randomInt(minimum, maximum);
                FieldSupport.setField(testInstance, field2, random);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Integer.class)) {
                annotation = field2.getAnnotation(TestEngine.Random.Integer.class);
                int minimum = annotation.minimum();
                int maximum = annotation.maximum();
                int random = RandomUtils.randomInt(minimum, maximum);
                FieldSupport.setField(testInstance, field2, random);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Long.class)) {
                annotation = field2.getAnnotation(TestEngine.Random.Long.class);
                long minimum = annotation.minimum();
                long maximum = annotation.maximum();
                long random = RandomUtils.randomLong(minimum, maximum);
                FieldSupport.setField(testInstance, field2, random);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Float.class)) {
                annotation = field2.getAnnotation(TestEngine.Random.Float.class);
                float minimum = annotation.minimum();
                float maximum = annotation.maximum();
                float random = RandomUtils.randomFloat(minimum, maximum);
                FieldSupport.setField(testInstance, field2, Float.valueOf(random));
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Double.class)) {
                annotation = field2.getAnnotation(TestEngine.Random.Double.class);
                double minimum = annotation.minimum();
                double maximum = annotation.maximum();
                double random = RandomUtils.randomDouble(minimum, maximum);
                FieldSupport.setField(testInstance, field2, random);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.BigInteger.class)) {
                annotation = field2.getAnnotation(TestEngine.Random.BigInteger.class);
                String minimum = annotation.minimum();
                String maximum = annotation.maximum();
                BigInteger random = RandomUtils.randomBigInteger(minimum, maximum);
                FieldSupport.setField(testInstance, field2, random);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.BigDecimal.class)) {
                annotation = field2.getAnnotation(TestEngine.Random.BigDecimal.class);
                String minimum = annotation.minimum();
                String maximum = annotation.maximum();
                BigDecimal random = RandomUtils.randomBigDecimal(minimum, maximum);
                FieldSupport.setField(testInstance, field2, random);
                continue;
            }
            if (!field2.isAnnotationPresent(TestEngine.Random.UUID.class)) continue;
            UUID random = UUID.randomUUID();
            FieldSupport.setField(testInstance, field2, random);
        }
    }

    private static void clearRandomFields(Class<?> testClass, Object testInstance, Predicate<Field> fieldPredicate) throws Throwable {
        List fields = ReflectionSupport.findFields(testClass, field -> fieldPredicate.test((Field)field) && HAS_RANDOM_ANNOTATION.test((Field)field), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Field field2 : fields) {
            if (field2.isAnnotationPresent(TestEngine.Random.Boolean.class)) {
                FieldSupport.setField(testInstance, field2, Boolean.FALSE);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Byte.class)) {
                FieldSupport.setField(testInstance, field2, (byte)0);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Character.class)) {
                FieldSupport.setField(testInstance, field2, Character.valueOf('\u0000'));
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Short.class)) {
                FieldSupport.setField(testInstance, field2, (short)0);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Integer.class)) {
                FieldSupport.setField(testInstance, field2, 0);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Long.class)) {
                FieldSupport.setField(testInstance, field2, 0L);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Float.class)) {
                FieldSupport.setField(testInstance, field2, Float.valueOf(0.0f));
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.Double.class)) {
                FieldSupport.setField(testInstance, field2, 0.0);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.BigInteger.class)) {
                FieldSupport.setField(testInstance, field2, null);
                continue;
            }
            if (field2.isAnnotationPresent(TestEngine.Random.BigDecimal.class)) {
                FieldSupport.setField(testInstance, field2, null);
                continue;
            }
            if (!field2.isAnnotationPresent(TestEngine.Random.UUID.class)) continue;
            FieldSupport.setField(testInstance, field2, null);
        }
    }
}

