/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.api.TestEngineExtension;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class Predicates {
    public static final Predicate<Class<?>> TEST_ENGINE_EXTENSION_CLASS = clazz -> {
        int modifiers = clazz.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isStatic(modifiers) && !clazz.isAnnotationPresent(TestEngine.Disabled.class) && TestEngineExtension.class.isAssignableFrom((Class<?>)clazz);
    };
    public static final Predicate<Field> ARGUMENT_FIELD = field -> {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && field.isAnnotationPresent(TestEngine.Argument.class);
    };
    public static final Predicate<Method> ARGUMENT_SUPPLIER_METHOD = method -> {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && method.isAnnotationPresent(TestEngine.ArgumentSupplier.class);
    };
    public static final Predicate<Field> STATIC_FIELD = field -> {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers);
    };
    public static final Predicate<Field> FIELD = field -> {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers);
    };
    public static final Predicate<Method> TEST_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && !method.isAnnotationPresent(TestEngine.Disabled.class) && method.isAnnotationPresent(TestEngine.Test.class);
    };
    public static final Predicate<Class<?>> TEST_CLASS = clazz -> {
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !clazz.isAnnotationPresent(TestEngine.Disabled.class) && !ReflectionSupport.findMethods((Class)clazz, TEST_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).isEmpty() && !ReflectionSupport.findMethods((Class)clazz, ARGUMENT_SUPPLIER_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).isEmpty();
    };
    public static final Predicate<Method> PREPARE_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && !method.isAnnotationPresent(TestEngine.Disabled.class) && method.isAnnotationPresent(TestEngine.Prepare.class);
    };
    public static final Predicate<Method> BEFORE_ALL_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && !method.isAnnotationPresent(TestEngine.Disabled.class) && method.isAnnotationPresent(TestEngine.BeforeAll.class);
    };
    public static final Predicate<Method> BEFORE_EACH_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && !method.isAnnotationPresent(TestEngine.Disabled.class) && method.isAnnotationPresent(TestEngine.BeforeEach.class);
    };
    public static final Predicate<Method> AFTER_EACH_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && !method.isAnnotationPresent(TestEngine.Disabled.class) && method.isAnnotationPresent(TestEngine.AfterEach.class);
    };
    public static final Predicate<Method> AFTER_ALL_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && !method.isAnnotationPresent(TestEngine.Disabled.class) && method.isAnnotationPresent(TestEngine.AfterAll.class);
    };
    public static final Predicate<Method> CONCLUDE_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && !method.isAnnotationPresent(TestEngine.Disabled.class) && method.isAnnotationPresent(TestEngine.Conclude.class);
    };

    private Predicates() {
    }
}

