/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.antublue.test.engine.internal.support.RandomAnnotationSupport;
import org.antublue.test.engine.internal.util.Predicates;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ClassTestDescriptor
extends ExecutableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassTestDescriptor.class);
    private final Class<?> testClass;
    private final List<Method> prepareMethods;
    private final List<Method> concludeMethods;
    private ExecutionRequest executionRequest;
    private Object testInstance;

    private ClassTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, List<Method> prepareMethods, List<Method> concludeMethods) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.prepareMethods = prepareMethods;
        this.concludeMethods = concludeMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    @Override
    public void execute(ExecutionRequest executionRequest, Object testInstance) {
        LOGGER.trace("execute(ExecutionRequest executionRequest)");
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getDisplayName());
        this.executionRequest = executionRequest;
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        this.throwableCollector.execute(this::setRandomFields);
        if (this.throwableCollector.isEmpty()) {
            this.throwableCollector.execute(this::createTestInstance);
            if (this.throwableCollector.isEmpty()) {
                this.throwableCollector.execute(this::prepare);
                if (this.throwableCollector.isEmpty()) {
                    this.execute();
                } else {
                    this.skip();
                }
                this.throwableCollector.execute(this::conclude);
            }
            this.throwableCollector.execute(this::destroyTestInstance);
        }
        this.throwableCollector.execute(this::clearRandomFields);
        this.stopWatch.stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.stopWatch.elapsedNanoseconds());
        List<Throwable> throwables = this.collectThrowables();
        if (throwables.isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", "PASS");
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getMetadata().put("testDescriptorStatus", "FAIL");
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwables.get(0)));
        }
    }

    @Override
    public void skip(ExecutionRequest executionRequest) {
        LOGGER.trace("skip(ExecutionRequest executionRequest)");
        this.stopWatch.stop();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getDisplayName());
        this.getMetadata().put("testDescriptorElapsedTime", this.stopWatch.elapsedNanoseconds());
        this.getMetadata().put("testDescriptorStatus", "SKIP");
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).skip(executionRequest);
            }
        });
        executionRequest.getEngineExecutionListener().executionSkipped((TestDescriptor)this, "Skipped");
    }

    private void setRandomFields() throws Throwable {
        LOGGER.trace("setRandomFields() testClass [%s]", (Object)this.testClass.getName());
        RandomAnnotationSupport.setRandomFields(this.testClass);
    }

    private void prepare() throws Throwable {
        LOGGER.trace("prepare() testClass [%s] testInstance [%s]", this.testClass.getName(), this.testInstance);
        for (Method method : this.prepareMethods) {
            LOGGER.trace("prepare() testClass [%s] testInstance [%s] method [%s]", this.testClass.getName(), this.testInstance, method);
            method.invoke(this.testInstance, new Object[0]);
        }
    }

    private void createTestInstance() throws Throwable {
        LOGGER.trace("createTestInstance() testClass [%s]", (Object)this.testClass.getName());
        this.testInstance = this.testClass.getDeclaredConstructor(null).newInstance(null);
        LOGGER.trace("createTestInstance() testClass [%s] testInstance [%s]", this.testClass.getName(), this.testInstance);
    }

    private void execute() {
        LOGGER.trace("execute() testClass [%s]", (Object)this.testClass.getName());
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ArgumentTestDescriptor) {
                ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                executableTestDescriptor.execute(this.executionRequest, this.testInstance);
            }
        });
    }

    private void skip() {
        LOGGER.trace("skip() testClass [%s]", (Object)this.testClass.getName());
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getDisplayName());
        this.executionRequest.getEngineExecutionListener().executionSkipped((TestDescriptor)this, "Skipped");
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ArgumentTestDescriptor) {
                ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                executableTestDescriptor.skip(this.executionRequest);
            }
        });
    }

    private void clearRandomFields() throws Throwable {
        LOGGER.trace("clearRandomFields() testClass [%s]", (Object)this.testClass.getName());
        RandomAnnotationSupport.clearRandomFields(this.testClass);
    }

    private void conclude() throws Throwable {
        LOGGER.trace("conclude() testClass [%s] testInstance [%s]", this.testClass.getName(), this.testInstance);
        for (Method method : this.concludeMethods) {
            LOGGER.trace("conclude() testClass [%s] testInstance [%s] method [%s]", this.testClass.getName(), this.testInstance, method);
            method.invoke(this.testInstance, new Object[0]);
        }
    }

    private void destroyTestInstance() {
        LOGGER.trace("destroyTestInstance() testClass [%s]", this.testClass.getName(), this.testInstance);
        this.testInstance = null;
    }

    public static ClassTestDescriptor create(UniqueId parentUniqueId, Class<?> testClass) {
        Preconditions.notNull((Object)parentUniqueId, (String)"parentUniqueId is null");
        Preconditions.notNull(testClass, (String)"testClass is null");
        UniqueId uniqueId = parentUniqueId.append(ClassTestDescriptor.class.getName(), testClass.getName());
        LOGGER.trace("uniqueId [%s]", (Object)uniqueId);
        String displayName = DisplayNameSupport.getDisplayName(testClass);
        LOGGER.trace("displayName [%s]", (Object)displayName);
        List<Method> prepareMethods = ReflectionSupport.findMethods(testClass, Predicates.PREPARE_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        prepareMethods = OrdererSupport.orderTestMethods(prepareMethods, HierarchyTraversalMode.TOP_DOWN);
        if (LOGGER.isTraceEnabled() && !prepareMethods.isEmpty()) {
            prepareMethods.forEach(method -> LOGGER.trace("prepare method [%s]", method));
        }
        List<Method> concludeMethods = ReflectionSupport.findMethods(testClass, Predicates.CONCLUDE_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        concludeMethods = OrdererSupport.orderTestMethods(concludeMethods, HierarchyTraversalMode.TOP_DOWN);
        if (LOGGER.isTraceEnabled() && !concludeMethods.isEmpty()) {
            concludeMethods.forEach(method -> LOGGER.trace("conclude method [%s]", method));
        }
        return new ClassTestDescriptor(uniqueId, displayName, testClass, prepareMethods, concludeMethods);
    }
}

