/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.support;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.concurrent.ThreadLocalRandom;

public class RandomSupport {
    private RandomSupport() {
    }

    public static boolean randomBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static int randomInt(int minimum, int maximum) {
        if (minimum == maximum) {
            return minimum;
        }
        int realMinimum = Math.min(minimum, maximum);
        int realMaximum = Math.max(minimum, maximum);
        int random = ThreadLocalRandom.current().nextInt(realMinimum, realMaximum);
        if (ThreadLocalRandom.current().nextBoolean()) {
            ++random;
        }
        return random;
    }

    public static long randomLong(long minimum, long maximum) {
        if (minimum == maximum) {
            return minimum;
        }
        long realMinimum = Math.min(minimum, maximum);
        long realMaximum = Math.max(minimum, maximum);
        long random = ThreadLocalRandom.current().nextLong(realMinimum, realMaximum);
        if (ThreadLocalRandom.current().nextBoolean()) {
            ++random;
        }
        return random;
    }

    public static float randomFloat(float minimum, float maximum) {
        if (minimum == maximum) {
            return minimum;
        }
        return RandomSupport.randomBigDecimal(BigDecimal.valueOf(minimum), BigDecimal.valueOf(maximum)).floatValue();
    }

    public static double randomDouble(double minimum, double maximum) {
        if (minimum == maximum) {
            return minimum;
        }
        return RandomSupport.randomBigDecimal(BigDecimal.valueOf(minimum), BigDecimal.valueOf(maximum)).doubleValue();
    }

    public static BigInteger randomBigInteger(String minimum, String maximum) {
        BigInteger maximumBigInteger;
        BigInteger minimumBigInteger;
        if (minimum.contains(".")) {
            throw new NumberFormatException(String.format("BigInteger minimum [%s] is invalid ", minimum));
        }
        if (maximum.contains(".")) {
            throw new NumberFormatException(String.format("BigInteger maximum [%s] is invalid", maximum));
        }
        try {
            minimumBigInteger = new BigInteger(minimum);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("BigDecimal minimum [%s] is invalid", minimum));
        }
        try {
            maximumBigInteger = new BigInteger(maximum);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("BigDecimal maximum [%s] is invalid", maximum));
        }
        if (minimumBigInteger.equals(maximumBigInteger)) {
            return new BigInteger(minimum);
        }
        if (maximumBigInteger.subtract(minimumBigInteger).abs().equals(BigDecimal.ONE)) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                return new BigInteger(minimum);
            }
            return new BigInteger(maximum);
        }
        if (minimumBigInteger.compareTo(maximumBigInteger) > 0) {
            BigInteger temp = maximumBigInteger;
            maximumBigInteger = minimumBigInteger;
            minimumBigInteger = temp;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        BigInteger range = maximumBigInteger.subtract(minimumBigInteger).add(BigInteger.ONE);
        BigInteger generated = new BigInteger(range.bitLength(), random);
        while (generated.compareTo(range) >= 0) {
            generated = new BigInteger(range.bitLength(), random);
        }
        return generated.add(minimumBigInteger);
    }

    public static BigDecimal randomBigDecimal(String minimum, String maximum) {
        BigDecimal maximummBigDecimal;
        BigDecimal minimumBigDecimal;
        try {
            minimumBigDecimal = new BigDecimal(minimum);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("BigDecimal minimum [%s] is invalid", minimum));
        }
        try {
            maximummBigDecimal = new BigDecimal(maximum);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("BigDecimal maximum [%s] is invalid", maximum));
        }
        return RandomSupport.randomBigDecimal(minimumBigDecimal, maximummBigDecimal);
    }

    private static BigDecimal randomBigDecimal(BigDecimal minimum, BigDecimal maximum) {
        if (minimum.equals(maximum)) {
            return minimum;
        }
        BigDecimal realMinimum = minimum;
        BigDecimal realMaximum = maximum;
        if (realMinimum.compareTo(realMaximum) < 0) {
            BigDecimal temp = realMinimum;
            realMinimum = realMaximum;
            realMaximum = temp;
        }
        int digitCount = Math.max(realMinimum.precision(), realMaximum.precision()) + 10;
        int bitCount = (int)((double)digitCount / Math.log10(2.0));
        BigDecimal alpha = new BigDecimal(new BigInteger(bitCount, ThreadLocalRandom.current())).movePointLeft(digitCount);
        return minimum.add(maximum.subtract(minimum).multiply(alpha, new MathContext(digitCount)));
    }
}

