/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.function.Predicate;

public class ParentLastClassLoader
extends ClassLoader {
    private final ClassLoader parent;
    private final Set<String> parentClassNames;
    private final Predicate<String> parentClassNamesPredicate;

    public ParentLastClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
        this.parentClassNames = null;
        this.parentClassNamesPredicate = null;
    }

    public ParentLastClassLoader(ClassLoader parent, Set<String> pareClassNames) {
        super(parent);
        this.parent = parent;
        this.parentClassNames = pareClassNames;
        this.parentClassNamesPredicate = null;
    }

    public ParentLastClassLoader(ClassLoader parent, Predicate<String> parentClassNamesPredicate) {
        super(parent);
        this.parent = parent;
        this.parentClassNames = null;
        this.parentClassNamesPredicate = parentClassNamesPredicate;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.parentClassNames != null && this.parentClassNames.contains(className)) {
            System.out.println("loadClass(" + className + ") parent");
            return this.parent.loadClass(className);
        }
        if (this.parentClassNamesPredicate != null && this.parentClassNamesPredicate.test(className)) {
            System.out.println("loadClass(" + className + ") parent");
            return this.parent.loadClass(className);
        }
        try {
            Class<?> loadedClass = this.findClass(className);
            if (loadedClass != null) {
                return loadedClass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.loadClass(className);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String classFileName = name.replace('.', '/') + ".class";
        InputStream classDataStream = this.getResourceAsStream(classFileName);
        if (classDataStream == null) {
            throw new ClassNotFoundException("Class not found: " + name);
        }
        try {
            byte[] classData = new byte[classDataStream.available()];
            classDataStream.read(classData);
            Class<?> clazz = this.defineClass(name, classData, 0, classData.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Failed to load class: " + name, e);
        }
        finally {
            try {
                classDataStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.parent != null) {
            url = this.parent.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentResources;
        final Enumeration<URL> childResources = this.findResources(name);
        Enumeration<URL> enumeration = parentResources = this.parent != null ? this.parent.getResources(name) : null;
        if (parentResources == null) {
            return childResources;
        }
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return childResources.hasMoreElements() || parentResources.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (childResources.hasMoreElements()) {
                    return (URL)childResources.nextElement();
                }
                return (URL)parentResources.nextElement();
            }
        };
    }
}

