/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestMethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.antublue.test.engine.internal.support.TagSupport;
import org.antublue.test.engine.internal.util.Predicates;
import org.antublue.test.engine.internal.util.StopWatch;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class EngineDiscoveryRequestResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineDiscoveryRequestResolver.class);
    private static final Configuration CONFIGURATION = Configuration.getInstance();

    public void resolveSelectors(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolveSelectors()");
        StopWatch stopWatch = new StopWatch();
        try {
            List<Class<?>> testClasses = EngineDiscoveryRequestResolver.resolveEngineDiscoveryRequest(engineDiscoveryRequest);
            this.filterTestClassesByClassName(testClasses);
            this.filterTestClassesByTags(testClasses);
            OrdererSupport.orderTestClasses(testClasses);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("working testClasses...");
                testClasses.forEach(c -> LOGGER.trace("testClass [%s]", (Object)c.getName()));
            }
            for (Class<?> testClass : testClasses) {
                EngineDiscoveryRequestResolver.buildClassTestDescriptor((TestDescriptor)engineDescriptor, testClass);
            }
            LOGGER.trace("pruning...");
            EngineDiscoveryRequestResolver.prune((TestDescriptor)engineDescriptor);
            EngineDiscoveryRequestResolver.shuffle(engineDescriptor);
        }
        catch (TestEngineException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestEngineException(t);
        }
        finally {
            stopWatch.stop();
            LOGGER.trace("resolveSelectors() %d ms", (Object)stopWatch.elapsedMilliseconds());
        }
    }

    private static void buildClassTestDescriptor(TestDescriptor parentTestDescriptor, Class<?> testClass) throws Throwable {
        LOGGER.trace("buildClassTestDescriptor() testClass [%s]", (Object)testClass.getName());
        ClassTestDescriptor classTestDescriptor = ClassTestDescriptor.create(parentTestDescriptor.getUniqueId(), testClass);
        parentTestDescriptor.addChild((TestDescriptor)classTestDescriptor);
        int testArgumentIndex = 0;
        List<Argument<?>> testArguments = EngineDiscoveryRequestResolver.getArguments(testClass);
        for (Argument<?> testArgument : testArguments) {
            EngineDiscoveryRequestResolver.buildArgumentTestDescriptor((TestDescriptor)classTestDescriptor, testClass, testArgument, testArgumentIndex);
            ++testArgumentIndex;
        }
    }

    private static void buildArgumentTestDescriptor(TestDescriptor parentTestDescriptor, Class<?> testClass, Argument<?> testArgument, int testArgumentIndex) {
        LOGGER.trace("buildArgumentTestDescriptor() testClass [%s] testArgument [%s] testArgumentIndex [%d]", testClass.getName(), testArgument.getName(), testArgumentIndex);
        ArgumentTestDescriptor argumentTestDescriptor = ArgumentTestDescriptor.create(parentTestDescriptor.getUniqueId(), testClass, testArgument, testArgumentIndex);
        parentTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
        EngineDiscoveryRequestResolver.buildTestMethodTestDescriptor((TestDescriptor)argumentTestDescriptor, testClass, testArgument);
    }

    private static void buildTestMethodTestDescriptor(TestDescriptor parentTestDescriptor, Class<?> testClass, Argument<?> testArgument) {
        LOGGER.trace("buildTestMethodTestDescriptor() testClass [%s] testArgument [%s]", testClass.getName(), testArgument.getName());
        List<Method> testMethods = ReflectionSupport.findMethods(testClass, Predicates.TEST_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        testMethods = OrdererSupport.orderTestMethods(testMethods, HierarchyTraversalMode.TOP_DOWN);
        EngineDiscoveryRequestResolver.filterTestMethodsByMethodName(testMethods);
        EngineDiscoveryRequestResolver.filterTestMethodsByTags(testMethods);
        for (Method testMethod : testMethods) {
            parentTestDescriptor.addChild((TestDescriptor)TestMethodTestDescriptor.create(parentTestDescriptor.getUniqueId(), testClass, testMethod, testArgument));
        }
    }

    private static List<Class<?>> resolveEngineDiscoveryRequest(EngineDiscoveryRequest engineDiscoveryRequest) throws Throwable {
        Class testClass;
        LOGGER.trace("resolveEngineDiscoveryRequest()");
        HashSet testClassSet = new HashSet();
        List discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            LOGGER.trace("ClasspathRootSelector...");
            ClasspathRootSelector classpathRootSelector = (ClasspathRootSelector)discoverySelector;
            LOGGER.trace("classpathRoot [%s]", (Object)classpathRootSelector.getClasspathRoot());
            List testClasses = ReflectionSupport.findAllClassesInClasspathRoot((URI)classpathRootSelector.getClasspathRoot(), Predicates.TEST_CLASS, className -> true);
            for (Class testClass2 : testClasses) {
                LOGGER.trace("testClass [%s]", (Object)testClass2.getName());
                List classNameFilters = engineDiscoveryRequest.getFiltersByType(ClassNameFilter.class);
                Predicate predicate = Filter.composeFilters((Collection)classNameFilters).toPredicate();
                if (!predicate.test(testClass2.getName())) {
                    LOGGER.trace("ignoring testClass [%s] (class name filter)", (Object)testClass2.getName());
                    continue;
                }
                List packageNameFilters = engineDiscoveryRequest.getFiltersByType(PackageNameFilter.class);
                predicate = Filter.composeFilters((Collection)packageNameFilters).toPredicate();
                if (!predicate.test(testClass2.getPackage().getName())) {
                    LOGGER.trace("ignoring testClass [%s] (package name filter)", (Object)testClass2.getName());
                    continue;
                }
                testClassSet.add(testClass2);
            }
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(PackageSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            LOGGER.trace("PackageSelector...");
            PackageSelector packageSelector = (PackageSelector)discoverySelector;
            String packageName = packageSelector.getPackageName();
            LOGGER.trace("packageName [%s]", (Object)packageName);
            List javaClasses = ReflectionSupport.findAllClassesInPackage((String)packageName, Predicates.TEST_CLASS, p -> true);
            testClassSet.addAll(javaClasses);
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClassSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            LOGGER.trace("ClassSelector...");
            ClassSelector classSelector = (ClassSelector)discoverySelector;
            testClass = classSelector.getJavaClass();
            if (Predicates.TEST_CLASS.test(testClass)) {
                testClassSet.add(testClass);
                continue;
            }
            LOGGER.trace("filtering javaClass [%s]", (Object)testClass.getName());
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(MethodSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            LOGGER.trace("MethodSelector...");
            MethodSelector methodSelector = (MethodSelector)discoverySelector;
            testClass = methodSelector.getJavaClass();
            Method testMethod = methodSelector.getJavaMethod();
            LOGGER.trace("testMethod [%s]", (Object)testMethod.getName());
            if (Predicates.TEST_CLASS.test(testClass) && Predicates.TEST_METHOD.test(testMethod)) {
                testClassSet.add(testClass);
                continue;
            }
            LOGGER.trace("filtering testClass [%s]", (Object)testClass.getName());
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            LOGGER.trace("UniqueIdSelector...");
            UniqueIdSelector uniqueIdSelector = (UniqueIdSelector)discoverySelector;
            UniqueId uniqueId = uniqueIdSelector.getUniqueId();
            List segments = uniqueId.getSegments();
            LOGGER.trace("uniqueId [%s]", (Object)uniqueId);
            for (UniqueId.Segment segment : segments) {
                String segmentType = segment.getType();
                if (!segmentType.equals(ClassTestDescriptor.class.getName())) continue;
                String javaClassName = segment.getValue();
                Class<?> testClass3 = Thread.currentThread().getContextClassLoader().loadClass(javaClassName);
                testClassSet.add(testClass3);
            }
        }
        ArrayList testClasses = new ArrayList(testClassSet);
        OrdererSupport.orderTestClasses(testClasses);
        return testClasses;
    }

    private static List<Argument<?>> getArguments(Class<?> testClass) throws Throwable {
        Iterator iterator;
        ArrayList testArguments = new ArrayList();
        Object object = EngineDiscoveryRequestResolver.getArumentSupplierMethod(testClass).invoke(null, (Object[])null);
        if (object == null) {
            return testArguments;
        }
        if (!(object instanceof Stream) && !(object instanceof Iterable)) {
            throw new TestClassDefinitionException(String.format("testClass [%s] @TestEngine.ArgumentSupplier must return a Stream<Argument> or Iterable<Argument>, type returned [%s]", testClass.getName(), object.getClass().getName()));
        }
        if (object instanceof Stream) {
            Stream stream = (Stream)object;
            iterator = stream.iterator();
        } else {
            Iterable iterable = (Iterable)object;
            iterator = iterable.iterator();
        }
        long index = 0L;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof Argument) {
                testArguments.add((Argument)o);
            } else {
                testArguments.add(Argument.of((String)("[" + index + "]"), o));
            }
            ++index;
        }
        return testArguments;
    }

    private static Method getArumentSupplierMethod(Class<?> testClass) {
        List methods = ReflectionSupport.findMethods(testClass, Predicates.ARGUMENT_SUPPLIER_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        return (Method)methods.get(0);
    }

    private void filterTestClassesByClassName(List<Class<?>> testClasses) {
        Class<?> clazz;
        Iterator<Class<?>> iterator;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestClassesByName()");
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.test.class.include.regex");
        if (optional.isPresent()) {
            LOGGER.trace(" %s [%s]", "antublue.test.engine.test.class.include.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                matcher.reset(clazz.getName());
                if (matcher.find()) continue;
                LOGGER.trace("removing testClass [%s]", (Object)clazz.getName());
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.class.exclude.regex")).isPresent()) {
            LOGGER.trace(" %s [%s]", "antublue.test.engine.test.class.exclude.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                matcher.reset(clazz.getName());
                if (!matcher.find()) continue;
                iterator.remove();
            }
        }
    }

    private void filterTestClassesByTags(List<Class<?>> testClasses) {
        String tag;
        Class<?> clazz;
        Iterator<Class<?>> iterator;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestClassesByTags()");
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.test.class.tag.include.regex");
        if (optional.isPresent()) {
            LOGGER.trace(" %s [%s]", "antublue.test.engine.test.class.tag.include.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                tag = TagSupport.getTag(clazz);
                if (tag == null) {
                    LOGGER.trace("removing testClass [%s]", (Object)clazz.getName());
                    iterator.remove();
                    continue;
                }
                matcher.reset(tag);
                if (matcher.find()) continue;
                LOGGER.trace("removing testClass [%s]", (Object)clazz.getName());
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.class.tag.exclude.regex")).isPresent()) {
            LOGGER.trace(" %s [%s]", "antublue.test.engine.test.class.tag.exclude.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                tag = TagSupport.getTag(clazz);
                if (tag == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                LOGGER.trace("removing testClass [%s]", (Object)clazz.getName());
                iterator.remove();
            }
        }
    }

    private static void filterTestMethodsByMethodName(List<Method> testMethods) {
        Method testMethod;
        Iterator<Method> iterator;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestMethodsByMethodName()");
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.test.method.include.regex");
        if (optional.isPresent()) {
            LOGGER.trace(" %s [%s]", "antublue.test.engine.test.method.include.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                matcher.reset(DisplayNameSupport.getDisplayName(testMethod));
                if (matcher.find()) continue;
                LOGGER.trace("removing testClass [%s] testMethod [%s]", testMethod.getClass().getName(), testMethod.getName());
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.method.exclude.regex")).isPresent()) {
            LOGGER.trace(" %s [%s]", "antublue.test.engine.test.method.exclude.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                matcher.reset(DisplayNameSupport.getDisplayName(testMethod));
                if (!matcher.find()) continue;
                LOGGER.trace("removing testClass [%s] testMethod [%s]", testMethod.getClass().getName(), testMethod.getName());
                iterator.remove();
            }
        }
    }

    private static void filterTestMethodsByTags(List<Method> testMethods) {
        String tag;
        Method testMethod;
        Iterator<Method> iterator;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestMethodsByTag()");
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.test.method.tag.include.regex");
        if (optional.isPresent()) {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.include.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                tag = TagSupport.getTag(testMethod);
                if (tag == null) {
                    iterator.remove();
                    continue;
                }
                matcher.reset(tag);
                if (matcher.find()) continue;
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.method.tag.exclude.regex")).isPresent()) {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.exclude.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                tag = TagSupport.getTag(testMethod);
                if (tag == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                iterator.remove();
            }
        }
    }

    private static void prune(TestDescriptor testDescriptor) {
        LinkedHashSet children = new LinkedHashSet(testDescriptor.getChildren());
        for (TestDescriptor child : children) {
            EngineDiscoveryRequestResolver.prune(child);
        }
        if (testDescriptor.isRoot()) {
            return;
        }
        if (testDescriptor.isContainer() && testDescriptor.getChildren().isEmpty()) {
            testDescriptor.removeFromHierarchy();
        }
    }

    private static void shuffle(EngineDescriptor engineDescriptor) {
        LOGGER.trace("shuffle()");
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.test.class.shuffle");
        if (optional.isPresent()) {
            LOGGER.trace("shuffling...");
            ArrayList testDescriptors = new ArrayList(engineDescriptor.getChildren());
            testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).removeChild(arg_0));
            Collections.shuffle(testDescriptors);
            testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).addChild(arg_0));
        }
    }
}

