/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.util.Optional;
import org.antublue.test.engine.Information;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.discovery.EngineDiscoveryRequestResolver;
import org.antublue.test.engine.internal.extension.TestEngineExtensionManager;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Executor;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class AntuBLUETestEngine
implements TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntuBLUETestEngine.class);
    public static final String ENGINE_ID = "antublue-test-engine";
    private static final String GROUP_ID = "org.antublue";
    private static final String ARTIFACT_ID = "test-engine";
    public static final String VERSION = Information.getInstance().getVersion();
    private static final String UNIQUE_ID = "[engine:antublue-test-engine]";

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        if (!UNIQUE_ID.equals(uniqueId.toString())) {
            return null;
        }
        Configuration.getInstance();
        LOGGER.trace("discover(" + uniqueId + ")");
        EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, this.getId());
        new EngineDiscoveryRequestResolver().resolveSelectors(engineDiscoveryRequest, engineDescriptor);
        return engineDescriptor;
    }

    public void execute(ExecutionRequest executionRequest) {
        if (executionRequest.getRootTestDescriptor().getChildren().isEmpty()) {
            return;
        }
        LOGGER.trace("execute() rootTestDescriptor children [%d]", (Object)executionRequest.getRootTestDescriptor().getChildren().size());
        executionRequest.getEngineExecutionListener().executionStarted(executionRequest.getRootTestDescriptor());
        ThrowableCollector throwableCollector = new ThrowableCollector(throwable -> true);
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> TestEngineExtensionManager.getInstance().prepare());
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                Executor executor = new Executor();
                executor.execute(ExecutionRequest.create((TestDescriptor)executionRequest.getRootTestDescriptor(), (EngineExecutionListener)executionRequest.getEngineExecutionListener(), (ConfigurationParameters)Configuration.getInstance()));
                executor.await();
            });
        }
        throwableCollector.execute(() -> TestEngineExtensionManager.getInstance().conclude());
        if (throwableCollector.isEmpty()) {
            executionRequest.getEngineExecutionListener().executionFinished(executionRequest.getRootTestDescriptor(), TestExecutionResult.successful());
        } else {
            executionRequest.getEngineExecutionListener().executionFinished(executionRequest.getRootTestDescriptor(), TestExecutionResult.failed((Throwable)throwableCollector.getThrowable()));
        }
    }
}

