/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestMethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.ArgumentAnnotationSupport;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.antublue.test.engine.internal.support.RandomAnnotationSupport;
import org.antublue.test.engine.internal.util.Predicates;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ArgumentTestDescriptor
extends ExecutableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument<?> testArgument;
    private final List<Method> beforeAllMethods;
    private final List<Method> afterAllMethods;
    private ExecutionRequest executionRequest;
    private Object testInstance;

    public ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, List<Method> beforeAllMethods, List<Method> afterAllMethods, Argument<?> testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.beforeAllMethods = beforeAllMethods;
        this.afterAllMethods = afterAllMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    @Override
    public void execute(ExecutionRequest executionRequest, Object testInstance) {
        LOGGER.trace("execute(ExecutionRequest executionRequest)");
        Preconditions.notNull((Object)testInstance, (String)"testInstance is null");
        this.testInstance = testInstance;
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", DisplayNameSupport.getDisplayName(this.testClass));
        this.getMetadata().put("testArgument", this.testArgument);
        this.executionRequest = executionRequest;
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        this.throwableCollector.execute(this::setArgumentFields);
        if (this.throwableCollector.isEmpty()) {
            this.throwableCollector.execute(this::setRandomFields);
            if (this.throwableCollector.isEmpty()) {
                this.throwableCollector.execute(this::beforeAllMethods);
                if (this.throwableCollector.isEmpty()) {
                    this.execute();
                } else {
                    this.skip();
                }
                this.throwableCollector.execute(this::afterAllMethods);
            }
            this.throwableCollector.execute(this::clearRandomFields);
        }
        this.throwableCollector.execute(this::clearArgumentFields);
        this.stopWatch.stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.stopWatch.elapsedNanoseconds());
        List<Throwable> throwables = this.collectThrowables();
        if (this.throwableCollector.isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", "PASS");
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getMetadata().put("testDescriptorStatus", "FAIL");
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwables.get(0)));
        }
    }

    @Override
    public void skip(ExecutionRequest executionRequest) {
        LOGGER.trace("skip(ExecutionRequest executionRequest)");
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getDisplayName());
        this.getMetadata().put("testDescriptorStatus", "SKIP");
        this.getMetadata().put("testDescriptorElapsedTime", 0L);
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).skip(executionRequest);
            }
        });
        executionRequest.getEngineExecutionListener().executionSkipped((TestDescriptor)this, String.format("Argument [%s] skipped", this.testArgument));
    }

    private void setArgumentFields() throws Throwable {
        LOGGER.trace("setArgumentFields() testClass [%s] testInstance [%s] testArgument [%s]", this.testInstance.getClass().getName(), this.testInstance, this.testArgument);
        ArgumentAnnotationSupport.setArgumentFields(this.testInstance, this.testArgument);
    }

    private void setRandomFields() throws Throwable {
        LOGGER.trace("setRandomFields() testClass [%s] testInstance [%s] testArgument [%s]", this.testInstance.getClass().getName(), this.testInstance, this.testArgument);
        RandomAnnotationSupport.setRandomFields(this.testInstance);
    }

    private void beforeAllMethods() throws Throwable {
        LOGGER.trace("beforeAllMethods() testClass [%s] testInstance [%s]", this.testInstance.getClass().getName(), this.testInstance);
        for (Method method : this.beforeAllMethods) {
            LOGGER.trace("beforeAllMethods() testClass [%s] testInstance [%s] method [%s]", this.testInstance.getClass().getName(), this.testInstance, method);
            method.invoke(this.testInstance, new Object[0]);
        }
    }

    private void execute() {
        LOGGER.trace("execute() testClass [%s]", (Object)this.testClass.getName());
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof TestMethodTestDescriptor) {
                ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                executableTestDescriptor.execute(this.executionRequest, this.testInstance);
            }
        });
    }

    private void skip() {
        LOGGER.trace("skip() testClass [%s]", (Object)this.testClass.getName());
        this.stopWatch.stop();
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof TestMethodTestDescriptor) {
                ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                executableTestDescriptor.skip(this.executionRequest);
            }
        });
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", DisplayNameSupport.getDisplayName(this.testClass));
        this.getMetadata().put("testArgument", this.testArgument);
    }

    private void afterAllMethods() throws Throwable {
        LOGGER.trace("afterAllMethods() testClass [%s] testInstance [%s]", this.testInstance.getClass().getName(), this.testInstance);
        for (Method method : this.afterAllMethods) {
            LOGGER.trace("afterAllMethods() testClass [%s] testInstance [%s] method [%s]", this.testInstance.getClass().getName(), this.testInstance, method);
            method.invoke(this.testInstance, new Object[0]);
        }
    }

    private void clearRandomFields() throws Throwable {
        LOGGER.trace("clearRandomFields() testClass [%s] testInstance [%s]", this.testInstance.getClass().getName(), this.testInstance);
        RandomAnnotationSupport.clearRandomFields(this.testInstance);
    }

    private void clearArgumentFields() throws Throwable {
        LOGGER.trace("clearArgumentFields() testClass [%s] testInstance [%s]", this.testInstance.getClass().getName(), this.testInstance);
        ArgumentAnnotationSupport.setArgumentFields(this.testInstance, null);
    }

    public static ArgumentTestDescriptor create(UniqueId parentUniqueId, Class<?> testClass, Argument<?> testArgument, int testArgumentIndex) {
        Preconditions.notNull((Object)parentUniqueId, (String)"parentUniqueId is null");
        Preconditions.notNull(testClass, (String)"testClass is null");
        Preconditions.notNull(testArgument, (String)"testArgument is null");
        UniqueId uniqueId = parentUniqueId.append(ArgumentTestDescriptor.class.getName(), testArgumentIndex + "/" + testArgument.getName());
        LOGGER.trace("uniqueId [%s]", (Object)uniqueId);
        String displayName = testArgument.getName();
        LOGGER.trace("displayName [%s]", (Object)displayName);
        List<Method> beforeAllMethods = ReflectionSupport.findMethods(testClass, Predicates.BEFORE_ALL_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        if (LOGGER.isTraceEnabled() && !beforeAllMethods.isEmpty()) {
            beforeAllMethods.forEach(method -> LOGGER.trace("beforeAll method [%s]", method));
        }
        beforeAllMethods = OrdererSupport.orderTestMethods(beforeAllMethods, HierarchyTraversalMode.TOP_DOWN);
        List<Method> afterAllMethods = ReflectionSupport.findMethods(testClass, Predicates.AFTER_ALL_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        if (LOGGER.isTraceEnabled() && !afterAllMethods.isEmpty()) {
            afterAllMethods.forEach(method -> LOGGER.trace("afterAll method [%s]", method));
        }
        afterAllMethods = OrdererSupport.orderTestMethods(afterAllMethods, HierarchyTraversalMode.BOTTOM_UP);
        return new ArgumentTestDescriptor(uniqueId, displayName, testClass, beforeAllMethods, afterAllMethods, testArgument);
    }
}

