/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.antublue.test.engine.internal.descriptor.Metadata;
import org.antublue.test.engine.internal.descriptor.MetadataTestDescriptor;
import org.antublue.test.engine.internal.execution.ExecutionContext;
import org.antublue.test.engine.internal.util.StopWatch;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

public abstract class ExecutableTestDescriptor
extends AbstractTestDescriptor
implements MetadataTestDescriptor {
    protected final ThrowableCollector throwableCollector = new ThrowableCollector();
    protected final Metadata metadata = new Metadata();
    protected final StopWatch stopWatch = new StopWatch();

    protected ExecutableTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public abstract void execute(ExecutionContext var1);

    public abstract void skip(ExecutionContext var1);

    public List<Throwable> collectThrowables() {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        if (this.throwableCollector.isNotEmpty()) {
            throwables.addAll(this.throwableCollector.getThrowables());
        }
        this.getChildren().forEach(testDescriptor -> {
            ExecutableTestDescriptor executableTestDescriptor;
            List<Throwable> childThrowables;
            if (testDescriptor instanceof ExecutableTestDescriptor && (childThrowables = (executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor).collectThrowables()) != null) {
                throwables.addAll(childThrowables);
            }
        });
        return throwables;
    }
}

