/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.discovery.Predicates;
import org.antublue.test.engine.internal.execution.ExecutionContext;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.MethodSupport;
import org.antublue.test.engine.internal.support.ObjectSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public class TestMethodTestDescriptor
extends ExecutableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestMethodTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument<?> testArgument;
    private final List<Method> beforeEachMethods;
    private final Method testMethod;
    private final List<Method> afterEachMethods;

    public TestMethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, List<Method> beforeEachMethods, Method testMethod, List<Method> afterEachMethods, Argument<?> testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.beforeEachMethods = beforeEachMethods;
        this.testMethod = testMethod;
        this.afterEachMethods = afterEachMethods;
        this.testArgument = testArgument;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("execute(ExecutionContext executionContext) %s", (Object)this.toString());
        }
        Object testInstance = executionContext.get("test.instance");
        Preconditions.notNull(testInstance, (String)"testInstance is null");
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", DisplayNameSupport.getDisplayName(this.testClass));
        this.getMetadata().put("testArgument", this.testArgument);
        this.getMetadata().put("testMethod", this.testMethod);
        this.getMetadata().put("testMethod.displayName", this.getDisplayName());
        executionContext.getExecutionRequest().getEngineExecutionListener().executionStarted((TestDescriptor)this);
        this.throwableCollector.execute(() -> this.beforeEach(executionContext));
        if (this.throwableCollector.isEmpty()) {
            this.throwableCollector.execute(() -> this.test(executionContext));
        }
        this.throwableCollector.execute(() -> this.afterEach(executionContext));
        this.stopWatch.stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.stopWatch.elapsedTime());
        List<Throwable> throwables = this.collectThrowables();
        this.throwableCollector.getThrowables().addAll(throwables);
        this.getMetadata().put("testDescriptorStatus", this.throwableCollector.isEmpty() ? "PASS" : "FAIL");
        executionContext.getExecutionRequest().getEngineExecutionListener().executionFinished((TestDescriptor)this, this.throwableCollector.toTestExecutionResult());
    }

    @Override
    public void skip(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("skip(ExecutionContext executionContext) %s", (Object)this.toString());
        }
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", DisplayNameSupport.getDisplayName(this.testClass));
        this.getMetadata().put("testArgument", this.testArgument);
        this.getMetadata().put("testMethod", this.testMethod);
        this.getMetadata().put("testMethod.displayName", this.getDisplayName());
        this.getMetadata().put("testDescriptorElapsedTime", 0);
        this.getMetadata().put("testDescriptorStatus", "SKIP");
        executionContext.getExecutionRequest().getEngineExecutionListener().executionSkipped((TestDescriptor)this, String.format("Argument [%s] test method [%s] skipped", this.testArgument, this.testMethod.getName()));
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "{ testClass [" + this.testClass.getName() + "] beforeEachMethods [" + ObjectSupport.toString(this.beforeEachMethods) + "] testMethod [" + this.testMethod.getName() + "] afterEachMethods [" + ObjectSupport.toString(this.afterEachMethods) + "] }";
    }

    private void beforeEach(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("beforeEach() testClass [%s] testInstance [%s]", testInstance.getClass().getName(), testInstance);
        }
        for (Method method : this.beforeEachMethods) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("beforeEach() testClass [%s] testInstance [%s] method [%s]", testInstance.getClass().getName(), testInstance, method);
            }
            method.invoke(testInstance, new Object[0]);
        }
    }

    private void test(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("test() testClass [%s] testInstance [%s] method [%s]", testInstance.getClass().getName(), testInstance, this.testMethod);
        }
        this.testMethod.invoke(testInstance, new Object[0]);
    }

    private void afterEach(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("afterEach() testClass [%s] testInstance [%s]", testInstance.getClass().getName(), testInstance);
        }
        for (Method method : this.afterEachMethods) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("afterEach() testClass [%s] testInstance [%s] method [%s]", testInstance.getClass().getName(), testInstance, method);
            }
            method.invoke(testInstance, new Object[0]);
        }
    }

    public static TestMethodTestDescriptor create(UniqueId parentUniqueId, Class<?> testClass, Method testMethod, Argument<?> testArgument) {
        Preconditions.notNull((Object)parentUniqueId, (String)"parentUniqueId is null");
        Preconditions.notNull(testClass, (String)"testClass is null");
        Preconditions.notNull((Object)testMethod, (String)"testMethod is null");
        Preconditions.notNull(testArgument, (String)"testArgument is null");
        UniqueId uniqueId = parentUniqueId.append(TestMethodTestDescriptor.class.getName(), testMethod.getName());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("uniqueId [%s]", (Object)uniqueId);
        }
        String displayName = DisplayNameSupport.getDisplayName(testMethod);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("displayName [%s]", (Object)displayName);
        }
        List<Method> beforeEachMethods = MethodSupport.findMethods(testClass, Predicates.BEFORE_EACH_METHOD, HierarchyTraversalMode.TOP_DOWN);
        beforeEachMethods = OrdererSupport.orderTestMethods(beforeEachMethods, HierarchyTraversalMode.TOP_DOWN);
        if (LOGGER.isTraceEnabled() && !beforeEachMethods.isEmpty()) {
            beforeEachMethods.forEach(method -> LOGGER.trace("beforeEachMethods method [%s]", method));
        }
        List<Method> afterEachMethods = MethodSupport.findMethods(testClass, Predicates.AFTER_EACH_METHOD, HierarchyTraversalMode.BOTTOM_UP);
        afterEachMethods = OrdererSupport.orderTestMethods(afterEachMethods, HierarchyTraversalMode.BOTTOM_UP);
        if (LOGGER.isTraceEnabled() && !afterEachMethods.isEmpty()) {
            afterEachMethods.forEach(method -> LOGGER.trace("afterEachMethods method [%s]", method));
        }
        return new TestMethodTestDescriptor(uniqueId, displayName, testClass, beforeEachMethods, testMethod, afterEachMethods, testArgument);
    }
}

