/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.discovery;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestMethodTestDescriptor;
import org.antublue.test.engine.internal.discovery.Predicates;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.ClassPathSupport;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.MethodSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.antublue.test.engine.internal.support.TagSupport;
import org.antublue.test.engine.internal.util.StopWatch;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class EngineDiscoveryRequestResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineDiscoveryRequestResolver.class);
    private static final Configuration CONFIGURATION = Configuration.getInstance();

    public void resolveSelectors(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolveSelectors()");
        StopWatch stopWatch = new StopWatch();
        try {
            List<Class<?>> testClasses = EngineDiscoveryRequestResolver.resolveEngineDiscoveryRequest(engineDiscoveryRequest);
            this.filterTestClassesByClassName(testClasses);
            this.filterTestClassesByTags(testClasses);
            OrdererSupport.orderTestClasses(testClasses);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("working testClasses...");
                testClasses.forEach(c -> LOGGER.trace("testClass [%s]", (Object)c.getName()));
            }
            for (Class<?> testClass : testClasses) {
                EngineDiscoveryRequestResolver.buildClassTestDescriptor((TestDescriptor)engineDescriptor, testClass);
            }
            LOGGER.trace("pruning...");
            EngineDiscoveryRequestResolver.prune((TestDescriptor)engineDescriptor);
            EngineDiscoveryRequestResolver.shuffle(engineDescriptor);
        }
        catch (TestEngineException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestEngineException(t);
        }
        finally {
            stopWatch.stop();
            LOGGER.trace("resolveSelectors() %d ms", (Object)stopWatch.elapsedTime().toMillis());
        }
    }

    private static void buildClassTestDescriptor(TestDescriptor parentTestDescriptor, Class<?> testClass) throws Throwable {
        LOGGER.trace("buildClassTestDescriptor() testClass [%s]", (Object)testClass.getName());
        ClassTestDescriptor classTestDescriptor = ClassTestDescriptor.create(parentTestDescriptor.getUniqueId(), testClass);
        parentTestDescriptor.addChild((TestDescriptor)classTestDescriptor);
        int testArgumentIndex = 0;
        List<Argument<?>> testArguments = EngineDiscoveryRequestResolver.getArguments(testClass);
        for (Argument<?> testArgument : testArguments) {
            EngineDiscoveryRequestResolver.buildArgumentTestDescriptor((TestDescriptor)classTestDescriptor, testClass, testArgument, testArgumentIndex);
            ++testArgumentIndex;
        }
    }

    private static void buildArgumentTestDescriptor(TestDescriptor parentTestDescriptor, Class<?> testClass, Argument<?> testArgument, int testArgumentIndex) {
        LOGGER.trace("buildArgumentTestDescriptor() testClass [%s] testArgument [%s] testArgumentIndex [%d]", testClass.getName(), testArgument.getName(), testArgumentIndex);
        ArgumentTestDescriptor argumentTestDescriptor = ArgumentTestDescriptor.create(parentTestDescriptor.getUniqueId(), testClass, testArgument, testArgumentIndex);
        parentTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
        EngineDiscoveryRequestResolver.buildTestMethodTestDescriptor((TestDescriptor)argumentTestDescriptor, testClass, testArgument);
    }

    private static void buildTestMethodTestDescriptor(TestDescriptor parentTestDescriptor, Class<?> testClass, Argument<?> testArgument) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("buildTestMethodTestDescriptor() testClass [%s] testArgument [%s]", testClass.getName(), testArgument.getName());
        }
        List<Method> testMethods = MethodSupport.findMethods(testClass, Predicates.TEST_METHOD, HierarchyTraversalMode.TOP_DOWN);
        testMethods = OrdererSupport.orderTestMethods(testMethods, HierarchyTraversalMode.TOP_DOWN);
        EngineDiscoveryRequestResolver.filterTestMethodsByMethodName(testMethods);
        EngineDiscoveryRequestResolver.filterTestMethodsByTags(testMethods);
        for (Method testMethod : testMethods) {
            parentTestDescriptor.addChild((TestDescriptor)TestMethodTestDescriptor.create(parentTestDescriptor.getUniqueId(), testClass, testMethod, testArgument));
        }
    }

    private static List<Class<?>> resolveEngineDiscoveryRequest(EngineDiscoveryRequest engineDiscoveryRequest) throws Throwable {
        Class testClass;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("resolveEngineDiscoveryRequest()");
        }
        HashSet testClassSet = new HashSet();
        List discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("ClasspathRootSelector...");
            }
            ClasspathRootSelector classpathRootSelector = (ClasspathRootSelector)discoverySelector;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("classpathRoot [%s]", (Object)classpathRootSelector.getClasspathRoot());
            }
            List<Class<?>> testClasses = ClassPathSupport.findClasses(classpathRootSelector.getClasspathRoot(), Predicates.TEST_CLASS);
            for (Class<?> testClass2 : testClasses) {
                List classNameFilters;
                Predicate predicate;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("testClass [%s]", (Object)testClass2.getName());
                }
                if (!(predicate = Filter.composeFilters((Collection)(classNameFilters = engineDiscoveryRequest.getFiltersByType(ClassNameFilter.class))).toPredicate()).test(testClass2.getName())) {
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.trace("ignoring testClass [%s] (class name filter)", (Object)testClass2.getName());
                    continue;
                }
                List packageNameFilters = engineDiscoveryRequest.getFiltersByType(PackageNameFilter.class);
                predicate = Filter.composeFilters((Collection)packageNameFilters).toPredicate();
                if (!predicate.test(testClass2.getPackage().getName())) {
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.trace("ignoring testClass [%s] (package name filter)", (Object)testClass2.getName());
                    continue;
                }
                testClassSet.add(testClass2);
            }
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(PackageSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("PackageSelector...");
            }
            PackageSelector packageSelector = (PackageSelector)discoverySelector;
            String packageName = packageSelector.getPackageName();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("packageName [%s]", (Object)packageName);
            }
            List<Class<?>> javaClasses = ClassPathSupport.findClasses(packageName, Predicates.TEST_CLASS);
            testClassSet.addAll(javaClasses);
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(ClassSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            ClassSelector classSelector;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("ClassSelector...");
            }
            if (Predicates.TEST_CLASS.test(testClass = (classSelector = (ClassSelector)discoverySelector).getJavaClass())) {
                testClassSet.add(testClass);
                continue;
            }
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("filtering javaClass [%s]", (Object)testClass.getName());
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(MethodSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("MethodSelector...");
            }
            MethodSelector methodSelector = (MethodSelector)discoverySelector;
            testClass = methodSelector.getJavaClass();
            Method testMethod = methodSelector.getJavaMethod();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("testMethod [%s]", (Object)testMethod.getName());
            }
            if (Predicates.TEST_CLASS.test(testClass) && Predicates.TEST_METHOD.test(testMethod)) {
                testClassSet.add(testClass);
                continue;
            }
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("filtering testClass [%s]", (Object)testClass.getName());
        }
        discoverySelectors = engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class);
        for (DiscoverySelector discoverySelector : discoverySelectors) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("UniqueIdSelector...");
            }
            UniqueIdSelector uniqueIdSelector = (UniqueIdSelector)discoverySelector;
            UniqueId uniqueId = uniqueIdSelector.getUniqueId();
            List segments = uniqueId.getSegments();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("uniqueId [%s]", (Object)uniqueId);
            }
            for (UniqueId.Segment segment : segments) {
                String segmentType = segment.getType();
                if (!segmentType.equals(ClassTestDescriptor.class.getName())) continue;
                String javaClassName = segment.getValue();
                Class<?> testClass3 = Thread.currentThread().getContextClassLoader().loadClass(javaClassName);
                testClassSet.add(testClass3);
            }
        }
        ArrayList testClasses = new ArrayList(testClassSet);
        OrdererSupport.orderTestClasses(testClasses);
        return testClasses;
    }

    private static List<Argument<?>> getArguments(Class<?> testClass) throws Throwable {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getArguments() testClass [%s]", (Object)testClass.getName());
        }
        ArrayList testArguments = new ArrayList();
        Object object = EngineDiscoveryRequestResolver.getArgumentSupplierMethod(testClass).invoke(null, (Object[])null);
        if (object == null) {
            return testArguments;
        }
        if (object instanceof Argument) {
            testArguments.add((Argument)object);
            return testArguments;
        }
        if (object instanceof Stream || object instanceof Iterable) {
            Iterator iterator;
            if (object instanceof Stream) {
                Stream stream = (Stream)object;
                iterator = stream.iterator();
            } else {
                Iterable iterable = (Iterable)object;
                iterator = iterable.iterator();
            }
            long index = 0L;
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o instanceof Argument) {
                    testArguments.add((Argument)o);
                } else {
                    testArguments.add(Argument.of((String)("argument[" + index + "]"), o));
                }
                ++index;
            }
        } else {
            testArguments.add(Argument.of((String)"argument", (Object)object));
        }
        return testArguments;
    }

    private static Method getArgumentSupplierMethod(Class<?> testClass) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getArgumentSupplierMethod() testClass [%s]", (Object)testClass.getName());
        }
        List<Method> methods = MethodSupport.findMethods(testClass, Predicates.ARGUMENT_SUPPLIER_METHOD, HierarchyTraversalMode.BOTTOM_UP);
        return methods.get(0);
    }

    private void filterTestClassesByClassName(List<Class<?>> testClasses) {
        Class<?> clazz;
        Iterator<Class<?>> iterator;
        Matcher matcher;
        Pattern pattern;
        Optional<String> optional;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("filterTestClassesByName()");
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.class.include.regex")).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(" %s [%s]", "antublue.test.engine.test.class.include.regex", optional.get());
            }
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                matcher.reset(clazz.getName());
                if (matcher.find()) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("removing testClass [%s]", (Object)clazz.getName());
                }
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.class.exclude.regex")).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(" %s [%s]", "antublue.test.engine.test.class.exclude.regex", optional.get());
            }
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                matcher.reset(clazz.getName());
                if (!matcher.find()) continue;
                iterator.remove();
            }
        }
    }

    private void filterTestClassesByTags(List<Class<?>> testClasses) {
        String tag;
        Class<?> clazz;
        Iterator<Class<?>> iterator;
        Matcher matcher;
        Pattern pattern;
        Optional<String> optional;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("filterTestClassesByTags()");
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.class.tag.include.regex")).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(" %s [%s]", "antublue.test.engine.test.class.tag.include.regex", optional.get());
            }
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                tag = TagSupport.getTag(clazz);
                if (tag == null) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("removing testClass [%s]", (Object)clazz.getName());
                    }
                    iterator.remove();
                    continue;
                }
                matcher.reset(tag);
                if (matcher.find()) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("removing testClass [%s]", (Object)clazz.getName());
                }
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.class.tag.exclude.regex")).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(" %s [%s]", "antublue.test.engine.test.class.tag.exclude.regex", optional.get());
            }
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testClasses.iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                tag = TagSupport.getTag(clazz);
                if (tag == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("removing testClass [%s]", (Object)clazz.getName());
                }
                iterator.remove();
            }
        }
    }

    private static void filterTestMethodsByMethodName(List<Method> testMethods) {
        Method testMethod;
        Iterator<Method> iterator;
        Matcher matcher;
        Pattern pattern;
        Optional<String> optional;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("filterTestMethodsByMethodName()");
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.method.include.regex")).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(" %s [%s]", "antublue.test.engine.test.method.include.regex", optional.get());
            }
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                matcher.reset(DisplayNameSupport.getDisplayName(testMethod));
                if (matcher.find()) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("removing testClass [%s] testMethod [%s]", testMethod.getClass().getName(), testMethod.getName());
                }
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.method.exclude.regex")).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(" %s [%s]", "antublue.test.engine.test.method.exclude.regex", optional.get());
            }
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                matcher.reset(DisplayNameSupport.getDisplayName(testMethod));
                if (!matcher.find()) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("removing testClass [%s] testMethod [%s]", testMethod.getClass().getName(), testMethod.getName());
                }
                iterator.remove();
            }
        }
    }

    private static void filterTestMethodsByTags(List<Method> testMethods) {
        String tag;
        Method testMethod;
        Iterator<Method> iterator;
        Matcher matcher;
        Pattern pattern;
        Optional<String> optional;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("filterTestMethodsByTag()");
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.method.tag.include.regex")).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.include.regex", optional.get());
            }
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                tag = TagSupport.getTag(testMethod);
                if (tag == null) {
                    iterator.remove();
                    continue;
                }
                matcher.reset(tag);
                if (matcher.find()) continue;
                iterator.remove();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.method.tag.exclude.regex")).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.exclude.regex", optional.get());
            }
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            iterator = testMethods.iterator();
            while (iterator.hasNext()) {
                testMethod = iterator.next();
                tag = TagSupport.getTag(testMethod);
                if (tag == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                iterator.remove();
            }
        }
    }

    private static void prune(TestDescriptor testDescriptor) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("prune() testDescriptor [%s]", (Object)testDescriptor);
        }
        LinkedHashSet children = new LinkedHashSet(testDescriptor.getChildren());
        for (TestDescriptor child : children) {
            EngineDiscoveryRequestResolver.prune(child);
        }
        if (testDescriptor.isRoot()) {
            return;
        }
        if (testDescriptor.isContainer() && testDescriptor.getChildren().isEmpty()) {
            testDescriptor.removeFromHierarchy();
        }
    }

    private static void shuffle(EngineDescriptor engineDescriptor) {
        Optional<String> optional;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("shuffle()");
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.class.shuffle")).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("shuffling...");
            }
            ArrayList testDescriptors = new ArrayList(engineDescriptor.getChildren());
            testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).removeChild(arg_0));
            Collections.shuffle(testDescriptors);
            testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).addChild(arg_0));
        }
    }
}

