/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.support;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.internal.discovery.Predicates;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.FieldSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;

public class ArgumentAnnotationSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentAnnotationSupport.class);

    private ArgumentAnnotationSupport() {
    }

    public static void setArgumentFields(Object testInstance, Argument<?> testArgument) throws Throwable {
        LOGGER.trace("injectArgumentFields() testClass [%s] testInstance [%s], testArgument [%s]", testInstance.getClass(), testInstance, testArgument != null ? testArgument.getName() : "null");
        List<Field> fields = FieldSupport.findFields(testInstance.getClass(), Predicates.ARGUMENT_FIELD, HierarchyTraversalMode.TOP_DOWN);
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            if (testArgument == null) {
                field.set(testInstance, null);
                continue;
            }
            if (fieldType.isAssignableFrom(testArgument.getClass())) {
                field.set(testInstance, testArgument);
                continue;
            }
            if (fieldType.isAssignableFrom(testArgument.getPayload().getClass())) {
                field.set(testInstance, testArgument.getPayload());
                continue;
            }
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                Type[] typeArguments;
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                for (Type typeArgument : typeArguments = parameterizedType.getActualTypeArguments()) {
                    System.out.println("Generic Type: " + typeArgument.getTypeName());
                }
            }
            throw new TestClassDefinitionException(String.format("Class [%s] field [%s] can't be assigned argument type [%s]", testInstance.getClass().getName(), field.getName(), ArgumentAnnotationSupport.toString(field)));
        }
    }

    private static String toString(Field field) {
        StringBuilder result = new StringBuilder();
        Class<?> fieldType = field.getType();
        result.append(fieldType.getName());
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            result.append("<");
            int i = 0;
            for (Type typeArgument : typeArguments) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(typeArgument.getTypeName());
                ++i;
            }
        }
        return result.toString();
    }
}

