/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.support;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.junit.platform.commons.support.ReflectionSupport;

public class ClassPathSupport {
    private static final ReentrantLock LOCK = new ReentrantLock(true);
    private static List<URI> URIS;

    private ClassPathSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URI> getClasspathURIs() {
        try {
            LOCK.lock();
            if (URIS == null) {
                String[] paths;
                LinkedHashSet<URI> uriSet = new LinkedHashSet<URI>();
                String classpath = System.getProperty("java.class.path");
                for (String path : paths = classpath.split(File.pathSeparator)) {
                    URI uri = new File(path).toURI();
                    uriSet.add(uri);
                }
                URIS = new ArrayList<URI>(uriSet);
            }
            List<URI> list = URIS;
            return list;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static List<URL> getClassPathURLS() {
        try {
            List<URI> uris = ClassPathSupport.getClasspathURIs();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (URI uri : uris) {
                urls.add(uri.toURL());
            }
            return urls;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static List<Class<?>> findClasses(URI uri, Predicate<Class<?>> predicate) {
        return new ArrayList(ReflectionSupport.findAllClassesInClasspathRoot((URI)uri, predicate, className -> true));
    }

    public static List<Class<?>> findClasses(String packageName, Predicate<Class<?>> predicate) {
        return new ArrayList(ReflectionSupport.findAllClassesInPackage((String)packageName, predicate, className -> true));
    }
}

