/*
 * Decompiled with CFR 0.152.
 */
package 48ebc8ca020a5ac33af85257ea798591.io.github.thunkware.vt.bridge;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class SempahoreExecutor
implements ExecutorService {
    private final ExecutorService delegate;
    private final Semaphore semaphore;

    public SempahoreExecutor(ExecutorService delegate, int permits) {
        this(delegate, new Semaphore(permits, true));
    }

    public SempahoreExecutor(ExecutorService delegate, Semaphore semaphore) {
        this.delegate = delegate;
        this.semaphore = semaphore;
    }

    private <T> List<Callable<T>> toSemaphoreCallables(Collection<? extends Callable<T>> callables) {
        return callables.stream().map(this::toSemaphoreCallable).collect(Collectors.toList());
    }

    private <T> Callable<T> toSemaphoreCallable(Callable<T> callable) {
        return () -> {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException();
            }
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                this.semaphore.release();
            }
        };
    }

    private Runnable toSemaphoreRunnable(Runnable command) {
        return () -> this.toSemaphoreCallable(() -> {
            command.run();
            return null;
        });
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.toSemaphoreRunnable(command));
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.toSemaphoreCallable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.toSemaphoreRunnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.toSemaphoreRunnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.toSemaphoreCallables(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.toSemaphoreCallables(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.toSemaphoreCallables(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.toSemaphoreCallables(tasks), timeout, unit);
    }
}

