/*
 * Decompiled with CFR 0.152.
 */
package 48ebc8ca020a5ac33af85257ea798591.io.github.thunkware.vt.bridge;

import 48ebc8ca020a5ac33af85257ea798591.io.github.thunkware.vt.bridge.CompatibilityPolicy;
import 48ebc8ca020a5ac33af85257ea798591.io.github.thunkware.vt.bridge.IncompatibilityException;
import 48ebc8ca020a5ac33af85257ea798591.io.github.thunkware.vt.bridge.ThreadFeature;
import 48ebc8ca020a5ac33af85257ea798591.io.github.thunkware.vt.bridge.ThreadProviderFactory;
import java.util.EnumMap;
import java.util.Map;

public class ThreadProviderConfig {
    private final Map<ThreadFeature, CompatibilityPolicy> policies = new EnumMap<ThreadFeature, CompatibilityPolicy>(ThreadFeature.class);

    public ThreadProviderConfig throwExceptionWhen(ThreadFeature threadFeature) {
        return this.setCompatibilityPolicy(threadFeature, CompatibilityPolicy.THROW_EXCEPTION);
    }

    public CompatibilityPolicy getCompatibilityPolicy(ThreadFeature threadFeature) {
        return this.policies.getOrDefault((Object)threadFeature, CompatibilityPolicy.BEST_EFFORT);
    }

    public ThreadProviderConfig setCompatibilityPolicy(ThreadFeature threadFeature, CompatibilityPolicy policy) {
        this.policies.put(threadFeature, policy);
        return this;
    }

    void reset() {
        this.policies.clear();
    }

    void enforceCompatibilityPolicy(ThreadFeature threadFeature) {
        CompatibilityPolicy compatibilityPolicy;
        if (!ThreadProviderFactory.isJava21() && (compatibilityPolicy = this.getCompatibilityPolicy(threadFeature)) == CompatibilityPolicy.THROW_EXCEPTION) {
            throw new IncompatibilityException("Java21 Virtual Threads feature unexpectedly accessed in Java8+ VM");
        }
    }
}

