/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

public abstract class AbstractTestDescriptor
implements TestDescriptor {
    private UniqueId uniqueId;
    private final String displayName;
    private final TestSource source;
    private TestDescriptor parent;
    protected final Set<TestDescriptor> children = Collections.synchronizedSet(new LinkedHashSet(16));

    protected AbstractTestDescriptor(UniqueId uniqueId, String displayName) {
        this(uniqueId, displayName, null);
    }

    protected AbstractTestDescriptor(UniqueId uniqueId, String displayName, TestSource source) {
        this.uniqueId = (UniqueId)Preconditions.notNull((Object)uniqueId, (String)"UniqueId must not be null");
        this.displayName = Preconditions.notBlank((String)displayName, (String)"displayName must not be null or blank");
        this.source = source;
    }

    public void setUniqueId(UniqueId uniqueId) {
        this.uniqueId = uniqueId;
    }

    public final UniqueId getUniqueId() {
        return this.uniqueId;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public Set<TestTag> getTags() {
        return Collections.emptySet();
    }

    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public final Optional<TestDescriptor> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public final void setParent(TestDescriptor parent) {
        this.parent = parent;
    }

    public final Set<? extends TestDescriptor> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    public void addChild(TestDescriptor child) {
        Preconditions.notNull((Object)child, (String)"child must not be null");
        child.setParent((TestDescriptor)this);
        this.children.add(child);
    }

    public void removeChild(TestDescriptor child) {
        Preconditions.notNull((Object)child, (String)"child must not be null");
        this.children.remove(child);
        child.setParent(null);
    }

    public void removeFromHierarchy() {
        Preconditions.condition((!this.isRoot() ? 1 : 0) != 0, (String)"cannot remove the root of a hierarchy");
        this.parent.removeChild((TestDescriptor)this);
        this.children.forEach(child -> child.setParent(null));
        this.children.clear();
    }

    public Optional<? extends TestDescriptor> findByUniqueId(UniqueId uniqueId) {
        Preconditions.notNull((Object)uniqueId, (String)"UniqueId must not be null");
        return this.getUniqueId().equals((Object)uniqueId) ? Optional.of(this) : this.children.stream().map(child -> child.findByUniqueId(uniqueId)).filter(Optional::isPresent).findAny().orElse(Optional.empty());
    }

    public final int hashCode() {
        return this.uniqueId.hashCode();
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TestDescriptor that = (TestDescriptor)other;
        return this.getUniqueId().equals((Object)that.getUniqueId());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getUniqueId();
    }
}

