/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestMethodTestDescriptor;
import org.antublue.test.engine.internal.discovery.Predicates;
import org.antublue.test.engine.internal.execution.ExecutionContext;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.ArgumentAnnotationSupport;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.MethodSupport;
import org.antublue.test.engine.internal.support.ObjectSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.antublue.test.engine.internal.support.RandomAnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ArgumentTestDescriptor
extends ExecutableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument<?> testArgument;
    private final List<Method> beforeAllMethods;
    private final List<Method> afterAllMethods;

    public ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, List<Method> beforeAllMethods, List<Method> afterAllMethods, Argument<?> testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.beforeAllMethods = beforeAllMethods;
        this.afterAllMethods = afterAllMethods;
    }

    @Override
    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("execute(ExecutionContext executionContext)");
        }
        Object testInstance = executionContext.get("test.instance");
        Preconditions.notNull(testInstance, (String)"testInstance is null");
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getParent().get().getDisplayName());
        this.getMetadata().put("testArgument", this.testArgument);
        executionContext.getExecutionRequest().getEngineExecutionListener().executionStarted((TestDescriptor)this);
        this.throwableCollector.execute(() -> this.setArgumentFields(executionContext));
        if (this.throwableCollector.isEmpty()) {
            this.throwableCollector.execute(() -> this.setRandomFields(executionContext));
            if (this.throwableCollector.isEmpty()) {
                this.throwableCollector.execute(() -> this.beforeAllMethods(executionContext));
                if (this.throwableCollector.isEmpty()) {
                    this.doExecute(executionContext);
                } else {
                    this.doSkip(executionContext);
                }
                this.throwableCollector.execute(() -> this.afterAllMethods(executionContext));
            }
            this.throwableCollector.execute(() -> this.clearRandomFields(executionContext));
        }
        this.throwableCollector.execute(() -> this.clearArgumentFields(executionContext));
        this.stopWatch.stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.stopWatch.elapsedTime());
        List<Throwable> throwables = this.collectThrowables();
        this.throwableCollector.getThrowables().addAll(throwables);
        this.getMetadata().put("testDescriptorStatus", this.throwableCollector.isEmpty() ? "PASS" : "FAIL");
        executionContext.getExecutionRequest().getEngineExecutionListener().executionFinished((TestDescriptor)this, this.throwableCollector.toTestExecutionResult());
    }

    @Override
    public void skip(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("skip(ExecutionContext executionContext)");
        }
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getDisplayName());
        this.getMetadata().put("testDescriptorStatus", "SKIP");
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).skip(executionContext);
            }
        });
        this.stopWatch.stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.stopWatch.elapsedTime());
        executionContext.getExecutionRequest().getEngineExecutionListener().executionSkipped((TestDescriptor)this, String.format("Argument [%s] skipped", this.testArgument));
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "{ testClass [" + this.testClass.getName() + "] beforeAllMethods [" + ObjectSupport.toString(this.beforeAllMethods) + "] afterAllMethods [" + ObjectSupport.toString(this.afterAllMethods) + "] }";
    }

    private void setArgumentFields(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("setArgumentFields() testClass [%s] testInstance [%s] testArgument [%s]", testInstance.getClass().getName(), testInstance, this.testArgument);
        }
        ArgumentAnnotationSupport.setArgumentFields(testInstance, this.testArgument);
    }

    private void setRandomFields(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("setRandomFields() testClass [%s] testInstance [%s] testArgument [%s]", testInstance.getClass().getName(), testInstance, this.testArgument);
        }
        if (testInstance != null) {
            RandomAnnotationSupport.setRandomFields(testInstance);
        }
    }

    private void beforeAllMethods(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("beforeAllMethods() testClass [%s] testInstance [%s]", testInstance.getClass().getName(), testInstance);
        }
        for (Method method : this.beforeAllMethods) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("beforeAllMethods() testClass [%s] testInstance [%s] method [%s]", testInstance.getClass().getName(), testInstance, method);
            }
            method.invoke(testInstance, new Object[0]);
        }
    }

    private void doExecute(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("execute() testClass [%s]", (Object)this.testClass.getName());
        }
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof TestMethodTestDescriptor) {
                ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                executableTestDescriptor.execute(executionContext);
            }
        });
    }

    private void doSkip(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("skip() testClass [%s]", (Object)this.testClass.getName());
        }
        this.stopWatch.stop();
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof TestMethodTestDescriptor) {
                ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                executableTestDescriptor.skip(executionContext);
            }
        });
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", DisplayNameSupport.getDisplayName(this.testClass));
        this.getMetadata().put("testArgument", this.testArgument);
    }

    private void afterAllMethods(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("afterAllMethods() testClass [%s] testInstance [%s]", testInstance.getClass().getName(), testInstance);
        }
        for (Method method : this.afterAllMethods) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("afterAllMethods() testClass [%s] testInstance [%s] method [%s]", testInstance.getClass().getName(), testInstance, method);
            }
            method.invoke(testInstance, new Object[0]);
        }
    }

    private void clearRandomFields(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("clearRandomFields() testClass [%s] testInstance [%s]", testInstance.getClass().getName(), testInstance);
        }
        if (testInstance != null) {
            RandomAnnotationSupport.clearRandomFields(testInstance);
        }
    }

    private void clearArgumentFields(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("clearArgumentFields() testClass [%s] testInstance [%s]", testInstance.getClass().getName(), testInstance);
        }
        ArgumentAnnotationSupport.setArgumentFields(testInstance, null);
    }

    public static ArgumentTestDescriptor create(UniqueId parentUniqueId, Class<?> testClass, Argument<?> testArgument, int testArgumentIndex) {
        Preconditions.notNull((Object)parentUniqueId, (String)"parentUniqueId is null");
        Preconditions.notNull(testClass, (String)"testClass is null");
        Preconditions.notNull(testArgument, (String)"testArgument is null");
        UniqueId uniqueId = parentUniqueId.append(ArgumentTestDescriptor.class.getName(), testArgumentIndex + "/" + testArgument.getName());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("uniqueId [%s]", (Object)uniqueId);
        }
        String displayName = testArgument.getName();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("displayName [%s]", (Object)displayName);
        }
        List<Method> beforeAllMethods = MethodSupport.findMethods(testClass, Predicates.BEFORE_ALL_METHOD, HierarchyTraversalMode.TOP_DOWN);
        if (LOGGER.isTraceEnabled() && !beforeAllMethods.isEmpty()) {
            beforeAllMethods.forEach(method -> LOGGER.trace("beforeAll method [%s]", method));
        }
        beforeAllMethods = OrdererSupport.orderTestMethods(beforeAllMethods, HierarchyTraversalMode.TOP_DOWN);
        List<Method> afterAllMethods = MethodSupport.findMethods(testClass, Predicates.AFTER_ALL_METHOD, HierarchyTraversalMode.BOTTOM_UP);
        if (LOGGER.isTraceEnabled() && !afterAllMethods.isEmpty()) {
            afterAllMethods.forEach(method -> LOGGER.trace("afterAll method [%s]", method));
        }
        afterAllMethods = OrdererSupport.orderTestMethods(afterAllMethods, HierarchyTraversalMode.BOTTOM_UP);
        return new ArgumentTestDescriptor(uniqueId, displayName, testClass, beforeAllMethods, afterAllMethods, testArgument);
    }
}

