/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.discovery.Predicates;
import org.antublue.test.engine.internal.execution.ExecutionContext;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.MethodSupport;
import org.antublue.test.engine.internal.support.ObjectSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.antublue.test.engine.internal.support.RandomAnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ClassTestDescriptor
extends ExecutableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassTestDescriptor.class);
    private final Class<?> testClass;
    private final List<Method> prepareMethods;
    private final List<Method> concludeMethods;

    private ClassTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, List<Method> prepareMethods, List<Method> concludeMethods) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.prepareMethods = prepareMethods;
        this.concludeMethods = concludeMethods;
    }

    @Override
    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("skip(ExecutionContext executionContext) %s", (Object)this.toString());
        }
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getDisplayName());
        executionContext.getExecutionRequest().getEngineExecutionListener().executionStarted((TestDescriptor)this);
        this.throwableCollector.execute(this::setRandomFields);
        if (this.throwableCollector.isEmpty()) {
            this.throwableCollector.execute(() -> this.createTestInstance(executionContext));
            if (this.throwableCollector.isEmpty()) {
                this.throwableCollector.execute(() -> this.prepare(executionContext));
                if (this.throwableCollector.isEmpty()) {
                    this.doExecute(executionContext);
                } else {
                    this.doSkip(executionContext);
                }
                this.throwableCollector.execute(() -> this.conclude(executionContext));
            }
            this.throwableCollector.execute(() -> this.destroyTestInstance(executionContext));
        }
        this.throwableCollector.execute(this::clearRandomFields);
        this.stopWatch.stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.stopWatch.elapsedTime());
        List<Throwable> throwables = this.collectThrowables();
        this.throwableCollector.getThrowables().addAll(throwables);
        this.getMetadata().put("testDescriptorStatus", this.throwableCollector.isEmpty() ? "PASS" : "FAIL");
        executionContext.getExecutionRequest().getEngineExecutionListener().executionFinished((TestDescriptor)this, this.throwableCollector.toTestExecutionResult());
    }

    @Override
    public void skip(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("skip(ExecutionContext executionContext) %s", (Object)this.toString());
        }
        this.stopWatch.reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getDisplayName());
        this.getMetadata().put("testDescriptorElapsedTime", this.stopWatch.elapsedTime());
        this.getMetadata().put("testDescriptorStatus", "SKIP");
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).skip(executionContext);
            }
        });
        this.stopWatch.stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.stopWatch.elapsedTime());
        executionContext.getExecutionRequest().getEngineExecutionListener().executionSkipped((TestDescriptor)this, "Skipped");
    }

    public List<ClassTestDescriptor> split(UniqueId parentUniqueId) {
        ArrayList<ClassTestDescriptor> classTestDescriptors = new ArrayList<ClassTestDescriptor>();
        if (this.testClass.isAnnotationPresent(TestEngine.ParallelArgumentTest.class) && this.getChildren().size() < 2) {
            classTestDescriptors.add(this);
            return classTestDescriptors;
        }
        int index = 0;
        for (TestDescriptor testDescriptor : this.getChildren()) {
            UniqueId uniqueId = parentUniqueId.append(ClassTestDescriptor.class.getName(), this.testClass.getName() + "[" + index + "]");
            String displayName = this.getDisplayName() + "[" + index + "]";
            Class<?> testClass = this.testClass;
            List<Method> prepareMethods = this.prepareMethods;
            List<Method> concludeMethods = this.concludeMethods;
            ClassTestDescriptor classTestDescriptor = new ClassTestDescriptor(uniqueId, displayName, testClass, prepareMethods, concludeMethods);
            classTestDescriptor.addChild(testDescriptor);
            classTestDescriptors.add(classTestDescriptor);
            ++index;
        }
        return classTestDescriptors;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "{ testClass [" + this.testClass.getName() + "] prepareMethods [" + ObjectSupport.toString(this.prepareMethods) + "] concludeMethods [" + ObjectSupport.toString(this.concludeMethods) + "] }";
    }

    private void setRandomFields() throws Throwable {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("setRandomFields() testClass [%s]", (Object)this.testClass.getName());
        }
        RandomAnnotationSupport.setRandomFields(this.testClass);
    }

    private void prepare(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("prepare() testClass [%s] testInstance [%s]", this.testClass.getName(), testInstance);
        }
        for (Method method : this.prepareMethods) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("prepare() testClass [%s] testInstance [%s] method [%s]", this.testClass.getName(), testInstance, method);
            }
            method.invoke(testInstance, new Object[0]);
        }
    }

    private void createTestInstance(ExecutionContext executionContext) throws Throwable {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("createTestInstance() testClass [%s]", (Object)this.testClass.getName());
        }
        Object testInstance = this.testClass.getDeclaredConstructor(null).newInstance(null);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("createTestInstance() testClass [%s] testInstance [%s]", this.testClass.getName(), testInstance);
        }
        executionContext.put("test.instance", testInstance);
    }

    private void doExecute(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("doExecute() testClass [%s]", (Object)this.testClass.getName());
        }
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ArgumentTestDescriptor) {
                ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                executableTestDescriptor.execute(executionContext);
            }
        });
    }

    private void doSkip(ExecutionContext executionContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("doSkip() testClass [%s]", (Object)this.testClass.getName());
        }
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", this.getDisplayName());
        executionContext.getExecutionRequest().getEngineExecutionListener().executionSkipped((TestDescriptor)this, "Skipped");
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ArgumentTestDescriptor) {
                ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                executableTestDescriptor.skip(executionContext);
            }
        });
    }

    private void clearRandomFields() throws Throwable {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("clearRandomFields() testClass [%s]", (Object)this.testClass.getName());
        }
        RandomAnnotationSupport.clearRandomFields(this.testClass);
    }

    private void conclude(ExecutionContext executionContext) throws Throwable {
        Object testInstance = executionContext.get("test.instance");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("conclude() testClass [%s] testInstance [%s]", this.testClass.getName(), testInstance);
        }
        if (testInstance != null) {
            for (Method method : this.concludeMethods) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("conclude() testClass [%s] testInstance [%s] method [%s]", this.testClass.getName(), testInstance, method);
                }
                method.invoke(testInstance, new Object[0]);
            }
        }
    }

    private void destroyTestInstance(ExecutionContext executionContext) {
        Object testInstance = executionContext.remove("test.instance");
        LOGGER.trace("destroyTestInstance() testClass [%s]", this.testClass.getName(), testInstance);
    }

    public static ClassTestDescriptor create(UniqueId parentUniqueId, Class<?> testClass) {
        Preconditions.notNull((Object)parentUniqueId, (String)"parentUniqueId is null");
        Preconditions.notNull(testClass, (String)"testClass is null");
        UniqueId uniqueId = parentUniqueId.append(ClassTestDescriptor.class.getName(), testClass.getName());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("uniqueId [%s]", (Object)uniqueId);
        }
        String displayName = DisplayNameSupport.getDisplayName(testClass);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("displayName [%s]", (Object)displayName);
        }
        List<Method> prepareMethods = MethodSupport.findMethods(testClass, Predicates.PREPARE_METHOD, HierarchyTraversalMode.TOP_DOWN);
        prepareMethods = OrdererSupport.orderTestMethods(prepareMethods, HierarchyTraversalMode.TOP_DOWN);
        if (LOGGER.isTraceEnabled() && !prepareMethods.isEmpty()) {
            prepareMethods.forEach(method -> LOGGER.trace("prepare method [%s]", method));
        }
        List<Method> concludeMethods = MethodSupport.findMethods(testClass, Predicates.CONCLUDE_METHOD, HierarchyTraversalMode.BOTTOM_UP);
        concludeMethods = OrdererSupport.orderTestMethods(concludeMethods, HierarchyTraversalMode.TOP_DOWN);
        if (LOGGER.isTraceEnabled() && !concludeMethods.isEmpty()) {
            concludeMethods.forEach(method -> LOGGER.trace("conclude method [%s]", method));
        }
        return new ClassTestDescriptor(uniqueId, displayName, testClass, prepareMethods, concludeMethods);
    }
}

