/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.execution;

import java.util.HashMap;
import java.util.Map;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;

public class ExecutionContext {
    private final Map<Object, Object> map;
    private final ExecutionRequest executionRequest;

    public ExecutionContext(ExecutionRequest executionRequest) {
        Preconditions.notNull((Object)executionRequest, (String)"executionRequest is null");
        this.map = new HashMap<Object, Object>();
        this.executionRequest = ExecutionRequest.create((TestDescriptor)executionRequest.getRootTestDescriptor(), (EngineExecutionListener)executionRequest.getEngineExecutionListener(), (ConfigurationParameters)Configuration.getInstance());
    }

    public ExecutionContext(ExecutionContext executionContext) {
        Preconditions.notNull((Object)executionContext, (String)"executionContext is null");
        this.map = new HashMap<Object, Object>();
        this.executionRequest = executionContext.executionRequest;
    }

    public ExecutionRequest getExecutionRequest() {
        return this.executionRequest;
    }

    public <T> T put(Object key, Object value) {
        Preconditions.notNull((Object)key, (String)"key is null");
        Preconditions.notNull((Object)value, (String)"value is null");
        return (T)this.map.put(key, value);
    }

    public <T> T get(Object key) {
        Preconditions.notNull((Object)key, (String)"key is null");
        return (T)this.map.get(key);
    }

    public <T> T get(Object key, Class<T> clazz) {
        Preconditions.notNull((Object)key, (String)"key is null");
        Preconditions.notNull(clazz, (String)"clazz is null");
        return clazz.cast(this.map.get(key));
    }

    public boolean containsKey(Object key) {
        Preconditions.notNull((Object)key, (String)"key is null");
        return this.map.containsKey(key);
    }

    public <T> T remove(Object key) {
        Preconditions.notNull((Object)key, (String)"key is null");
        return (T)this.map.remove(key);
    }

    public <T> T remove(Object key, Class<T> clazz) {
        Preconditions.notNull((Object)key, (String)"key is null");
        Preconditions.notNull(clazz, (String)"clazz is null");
        return clazz.cast(this.map.remove(key));
    }
}

