/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.execution.impl;

import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.execution.ExecutionContext;
import org.antublue.test.engine.internal.execution.ExecutionContextExecutor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.BlockingRejectedExecutionHandler;
import org.antublue.test.engine.internal.util.NamedThreadFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class PlatformThreadsExecutionContextExecutor
implements ExecutionContextExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformThreadsExecutionContextExecutor.class);
    private static final int MAX_THREAD_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
    private final CountDownLatch countDownLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContext executionContext) {
        try {
            LOGGER.trace("execute() children [%d]", (Object)executionContext.getExecutionRequest().getRootTestDescriptor().getChildren().size());
            EngineExecutionListener engineExecutionListener = executionContext.getExecutionRequest().getEngineExecutionListener();
            TestDescriptor rootTestDescriptor = executionContext.getExecutionRequest().getRootTestDescriptor();
            ExecutorService executorService = null;
            AtomicReference<CountDownLatch> countDownLatch = new AtomicReference<CountDownLatch>();
            try {
                ConfigurationParameters configurationParameters = executionContext.getExecutionRequest().getConfigurationParameters();
                int threadCount = configurationParameters.get("antublue.test.engine.thread.count").map(value -> {
                    try {
                        int intValue = Integer.parseInt(value);
                        if (intValue < 1) {
                            throw new TestEngineException(String.format("Invalid thread count [%d]", intValue));
                        }
                        return intValue;
                    }
                    catch (NumberFormatException e) {
                        throw new TestEngineException(String.format("Invalid thread count [%s]", value), e);
                    }
                }).orElse(MAX_THREAD_COUNT);
                LOGGER.trace("%s = [%d]", "antublue.test.engine.thread.count", threadCount);
                executorService = new ThreadPoolExecutor(threadCount, threadCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(threadCount * 10), new NamedThreadFactory("test-engine-%02d"), new BlockingRejectedExecutionHandler());
                engineExecutionListener.executionStarted(executionContext.getExecutionRequest().getRootTestDescriptor());
                Set testDescriptors = rootTestDescriptor.getChildren();
                LOGGER.trace("test descriptor count [%d]", (Object)testDescriptors.size());
                countDownLatch.set(new CountDownLatch(testDescriptors.size()));
                for (TestDescriptor testDescriptor : testDescriptors) {
                    if (!(testDescriptor instanceof ExecutableTestDescriptor)) continue;
                    ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                    executorService.submit(() -> {
                        try {
                            executableTestDescriptor.execute(new ExecutionContext(executionContext));
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                        }
                        finally {
                            ((CountDownLatch)countDownLatch.get()).countDown();
                        }
                    });
                }
            }
            finally {
                try {
                    ((CountDownLatch)countDownLatch.get()).await();
                }
                catch (InterruptedException interruptedException) {}
                if (executorService != null) {
                    executorService.shutdown();
                }
            }
            engineExecutionListener.executionFinished(rootTestDescriptor, TestExecutionResult.successful());
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    @Override
    public void await() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

