/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.execution.impl;

import 48ebc8ca020a5ac33af85257ea798591.io.github.thunkware.vt.bridge.ThreadTool;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.execution.ExecutionContext;
import org.antublue.test.engine.internal.execution.ExecutionContextExecutor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class VirtualThreadsExecutionContextExecutor
implements ExecutionContextExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualThreadsExecutionContextExecutor.class);
    private static final int MAX_THREAD_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
    private final CountDownLatch countDownLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContext executionContext) {
        try {
            LOGGER.trace("execute() children [%d]", (Object)executionContext.getExecutionRequest().getRootTestDescriptor().getChildren().size());
            EngineExecutionListener engineExecutionListener = executionContext.getExecutionRequest().getEngineExecutionListener();
            TestDescriptor rootTestDescriptor = executionContext.getExecutionRequest().getRootTestDescriptor();
            AtomicReference<CountDownLatch> countDownLatch = new AtomicReference<CountDownLatch>();
            try {
                ConfigurationParameters configurationParameters = executionContext.getExecutionRequest().getConfigurationParameters();
                int threadCount = configurationParameters.get("antublue.test.engine.thread.count").map(value -> {
                    try {
                        int intValue = Integer.parseInt(value);
                        if (intValue < 1) {
                            throw new TestEngineException(String.format("Invalid thread count [%d]", intValue));
                        }
                        return intValue;
                    }
                    catch (NumberFormatException e) {
                        throw new TestEngineException(String.format("Invalid thread count [%s]", value), e);
                    }
                }).orElse(MAX_THREAD_COUNT);
                LOGGER.trace("%s = [%d]", "antublue.test.engine.thread.count", threadCount);
                engineExecutionListener.executionStarted(executionContext.getExecutionRequest().getRootTestDescriptor());
                Set testDescriptors = rootTestDescriptor.getChildren();
                LOGGER.trace("test descriptor count [%d]", (Object)testDescriptors.size());
                countDownLatch.set(new CountDownLatch(testDescriptors.size()));
                Semaphore semaphore = new Semaphore(threadCount);
                AtomicInteger threadId = new AtomicInteger(1);
                for (TestDescriptor testDescriptor : testDescriptors) {
                    if (!(testDescriptor instanceof ExecutableTestDescriptor)) continue;
                    ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                    try {
                        semaphore.acquire();
                        Thread thread = ThreadTool.unstartedVirtualThread(() -> {
                            try {
                                executableTestDescriptor.execute(new ExecutionContext(executionContext));
                            }
                            catch (Throwable t) {
                                t.printStackTrace(System.err);
                            }
                            finally {
                                ((CountDownLatch)countDownLatch.get()).countDown();
                                threadId.decrementAndGet();
                                semaphore.release();
                            }
                        });
                        thread.setName(String.format("test-engine-vt-%02d", threadId.getAndIncrement()));
                        thread.start();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                try {
                    ((CountDownLatch)countDownLatch.get()).await();
                }
                catch (InterruptedException interruptedException) {}
            }
            engineExecutionListener.executionFinished(rootTestDescriptor, TestExecutionResult.successful());
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    @Override
    public void await() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

