/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antublue.test.engine.api.TestEngineExtension;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.discovery.Predicates;
import org.antublue.test.engine.internal.support.ClassPathSupport;
import org.antublue.test.engine.internal.support.ObjectSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;

public class TestEngineExtensionManager {
    private final List<TestEngineExtension> testEngineExtensions = new ArrayList<TestEngineExtension>();
    private boolean initialized;

    private TestEngineExtensionManager() {
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            List<Class<?>> classes = ClassPathSupport.findClasses(Predicates.TEST_ENGINE_EXTENSION_CLASS);
            OrdererSupport.orderTestClasses(classes);
            for (Class<?> clazz : classes) {
                try {
                    this.testEngineExtensions.add((TestEngineExtension)ObjectSupport.createObject(clazz));
                }
                catch (Throwable t) {
                    throw new TestEngineException(t);
                }
            }
            this.initialized = true;
        }
    }

    public void initializeCallback() throws Throwable {
        this.initialize();
        for (TestEngineExtension testEngineExtension : this.testEngineExtensions) {
            testEngineExtension.initializeCallback();
        }
    }

    public List<Throwable> destroyCallback() {
        this.initialize();
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        ArrayList<TestEngineExtension> testEngineExtensions = new ArrayList<TestEngineExtension>(this.testEngineExtensions);
        Collections.reverse(testEngineExtensions);
        for (TestEngineExtension testEngineExtension : testEngineExtensions) {
            try {
                testEngineExtension.destroyCallback();
            }
            catch (Throwable t) {
                throwables.add(t);
            }
        }
        return throwables;
    }

    public static TestEngineExtensionManager getInstance() {
        return SingletonHolder.SINGLETON;
    }

    private static class SingletonHolder {
        public static final TestEngineExtensionManager SINGLETON = new TestEngineExtensionManager();

        private SingletonHolder() {
        }
    }
}

