/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class StopWatch {
    private long startNanoTime;
    private Long stopNanoTime;

    public StopWatch() {
        this.reset();
    }

    public StopWatch reset() {
        this.startNanoTime = System.nanoTime();
        this.stopNanoTime = null;
        return this;
    }

    public StopWatch stop() {
        this.stopNanoTime = System.nanoTime();
        return this;
    }

    public Duration elapsedTime() {
        if (this.stopNanoTime == null) {
            return Duration.of(System.nanoTime() - this.startNanoTime, ChronoUnit.NANOS);
        }
        return Duration.of(this.stopNanoTime - this.startNanoTime, ChronoUnit.NANOS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StopWatch stopWatch = (StopWatch)o;
        return this.startNanoTime == stopWatch.startNanoTime && Objects.equals(this.stopNanoTime, stopWatch.stopNanoTime);
    }

    public int hashCode() {
        return Objects.hash(this.startNanoTime, this.stopNanoTime);
    }
}

